/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitScheduler;

public class SpeedDemon
extends Talent {
    private static String name = "SpeedDemon";
    private static String description = "While sprinting, gain a stacking movement speed bonus each time you jump (resets when sprinting cancels)";
    private static String tree = "Agility";
    private static int requiredLevel = 33;
    private static Material icon = Material.GOLDEN_BOOTS;
    private static int slot = 33;

    public SpeedDemon() {
        super(name, description, tree, requiredLevel);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new SpeedDemon(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
        SpeedDemon.scheduler();
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    public static void scheduler() {
        BukkitScheduler scheduler = Bukkit.getServer().getScheduler();
        scheduler.scheduleSyncRepeatingTask((Plugin)UltraSkills.getPlugin(), () -> {
            double defaultSpeed = 0.1;
            NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "speed-demon-stacks");
            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                if (!p.isSprinting()) {
                    p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)0);
                    p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(defaultSpeed);
                }
                if ((Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) <= 0) continue;
                p.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED).setBaseValue(defaultSpeed * (1.0 + 0.1 * (double)((Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER)).intValue()));
            }
        }, 0L, 20L);
    }

    @EventHandler
    public void PlayerJump(PlayerJumpEvent e) {
        Player p = e.getPlayer();
        if (!SpeedDemon.hasAbility(p)) {
            return;
        }
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "speed-demon-stacks");
        p.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)((Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) + 1));
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        NamespacedKey key = new NamespacedKey((Plugin)UltraSkills.getPlugin(), "speed-demon-stacks");
        if (!p.getPersistentDataContainer().has(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "speed-demon-stacks"), PersistentDataType.INTEGER)) {
            p.getPersistentDataContainer().set(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "speed-demon-stacks"), PersistentDataType.INTEGER, (Object)0);
        }
        if ((Integer)p.getPersistentDataContainer().get(key, PersistentDataType.INTEGER) != 0) {
            p.getPersistentDataContainer().set(new NamespacedKey((Plugin)UltraSkills.getPlugin(), "speed-demon-stacks"), PersistentDataType.INTEGER, (Object)0);
        }
    }
}

