/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.skillgroups.Agility;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import me.ultra42.ultraskills.utilities.airborne.Airborne;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Slingshot
extends Talent {
    private static String name = "Slingshot";
    private static String description = "Crouching charges your jump to be higher.";
    private static String tree = "Agility";
    private static int requiredLevel = 3;
    private static Material icon = Material.SLIME_BALL;
    private static int slot = 3;

    public Slingshot() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Slingshot(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerCrouch(PlayerToggleSneakEvent event) {
        final Player p = event.getPlayer();
        if (!Slingshot.hasAbility(p)) {
            return;
        }
        final int agility_level = Agility.getLevel(p, "Agility");
        final Location starting_loc = p.getLocation();
        if (event.isSneaking() && PersistentDataUtility.readInt((Entity)p, name, 0) == 0 && Airborne.isOnGround((Entity)p)) {
            PersistentDataUtility.store((Entity)p, name, 1);
            new BukkitRunnable(){

                public void run() {
                    if (!p.isSneaking() || PersistentDataUtility.readInt((Entity)p, name, 0) == 0 || p.getLocation().getX() != starting_loc.getX() || p.getLocation().getZ() != starting_loc.getZ()) {
                        this.cancel();
                    }
                    if (p.isSneaking() && PersistentDataUtility.readInt((Entity)p, name, 0) <= agility_level) {
                        PersistentDataUtility.store((Entity)p, name, PersistentDataUtility.readInt((Entity)p, name) + 1);
                        p.playSound(p.getLocation(), Sound.BLOCK_SLIME_BLOCK_HIT, 1.0f, (float)Math.log((double)PersistentDataUtility.readInt((Entity)p, name, 0) * 0.5));
                    }
                    Slingshot.this.generateParticles(p.getLocation(), p.getWorld(), PersistentDataUtility.readInt((Entity)p, name, 0));
                    Slingshot.this.createSlimeRing(p, (double)PersistentDataUtility.readInt((Entity)p, name, 0) * 0.05 + 0.5);
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 10L, 10L);
        } else if (!event.isSneaking()) {
            PersistentDataUtility.store((Entity)p, name, 0);
        }
    }

    @EventHandler
    public void PlayerJump(PlayerJumpEvent e) {
        final Player p = e.getPlayer();
        if (!Slingshot.hasAbility(p) || PersistentDataUtility.readInt((Entity)p, name, 0) == 0) {
            return;
        }
        final int stacks = PersistentDataUtility.readInt((Entity)p, name, 0);
        PersistentDataUtility.store((Entity)p, name, 0);
        Vector direction = p.getLocation().getDirection();
        final Vector velocity = direction.multiply(stacks / 2);
        new BukkitRunnable(){

            public void run() {
                p.setVelocity(velocity);
                p.playSound(p.getLocation(), Sound.ENTITY_SLIME_JUMP, 1.0f, 2.0f - 0.075f * (float)stacks);
                p.setFoodLevel(p.getFoodLevel() - 1);
                this.cancel();
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 5L, 1L);
    }

    public void generateParticles(Location loc, World world, int count) {
        world.spawnParticle(Particle.SLIME, loc, count, 0.5, 0.5, 0.5, 0.0);
    }

    public void createSlimeRing(Player player, double radius) {
        Location playerLocation = player.getLocation();
        double x = playerLocation.getX();
        double y = playerLocation.getY();
        double z = playerLocation.getZ();
        for (double theta = 0.0; theta <= 360.0; theta += 5.0) {
            double xPos = x + radius * Math.cos(Math.toRadians(theta));
            double zPos = z + radius * Math.sin(Math.toRadians(theta));
            player.spawnParticle(Particle.SLIME, xPos, y, zPos, 0, 0.0, 0.0, 0.0);
        }
    }
}

