/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import java.time.Instant;
import java.util.HashMap;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.Skill;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class SkyWalker
extends Skill {
    public static int range = 10;
    public static int num_blocks = 10;
    public static long duration = 10L;
    public static long cooldown = 3L;
    public static HashMap<Block, Instant> skyblocks = new HashMap();

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, "SkyWalker");
    }

    public static void unlockAbility(Player p) {
        AbilityManager.putCooldown(p, "SkyWalker", 0);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (!SkyWalker.hasAbility(e.getPlayer())) {
            SkyWalker.unlockAbility(e.getPlayer());
        }
    }

    public static Location getLocationNearPlayer(Player p, int range) {
        Vector v = p.getLocation().getDirection();
        v.multiply(Math.random() * (double)range);
        v.setX(v.getX() * (double)range * Math.random());
        v.setZ(v.getZ() * (double)range * Math.random());
        v.setY(v.getY() * Math.random());
        Location l = p.getLocation().add(v);
        UltraSkills.getPlugin().getLogger().info(String.valueOf(v));
        return l;
    }

    @EventHandler
    public void onPlayerRightClick(PlayerInteractEvent e) {
        if (e.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && (e.getHand().equals((Object)EquipmentSlot.HAND) && e.getPlayer().getInventory().getItemInMainHand().getType().equals((Object)Material.FEATHER) || e.getHand().equals((Object)EquipmentSlot.OFF_HAND) && e.getPlayer().getInventory().getItemInOffHand().getType().equals((Object)Material.FEATHER))) {
            Player p = e.getPlayer();
            SkyWalker.indicators(p);
            World w = p.getWorld();
            Location l = p.getLocation();
            for (int i = 0; i < num_blocks; ++i) {
                Block b = w.getBlockAt(SkyWalker.getLocationNearPlayer(p, range));
                if (b.getType() != Material.AIR) continue;
                b.setType(Material.MANGROVE_LEAVES);
                p.sendBlockChange(l, b.getBlockData());
                new BukkitRunnable(){

                    public void run() {
                    }
                }.runTaskLater((Plugin)UltraSkills.getPlugin(), 20L * duration);
            }
        }
    }

    public static void indicators(Player p) {
        for (int i = 0; i < 20; ++i) {
            p.spawnParticle(Particle.CLOUD, p.getEyeLocation(), 1, Math.random() * 5.0, Math.random() * 5.0, Math.random() * 5.0);
        }
        UltraSkills.getPlugin().getLogger().info(p.getName() + " strolls through the clouds.)");
    }
}

