/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;

public class RaceCart
extends Talent {
    private static String name = "RaceCart";
    private static String description = "While in a minecart, attempting to break minecarts speeds them up; crouching brakes and only makes you exit when stationary.";
    private static String tree = "Agility";
    private static int requiredLevel = 13;
    private static Material icon = Material.MINECART;
    private static int slot = 13;

    public RaceCart() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new RaceCart(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void punchMinecart(PlayerInteractEvent e) {
        Player p = e.getPlayer();
        if (!RaceCart.hasAbility(p)) {
            return;
        }
        if (!e.getAction().equals((Object)Action.LEFT_CLICK_AIR) && !e.getAction().equals((Object)Action.LEFT_CLICK_BLOCK)) {
            return;
        }
        if (p.getTargetEntity(5) == null || !p.getTargetEntity(5).getType().equals((Object)EntityType.MINECART)) {
            return;
        }
        final Minecart cart = (Minecart)p.getTargetEntity(5);
        cart.setMaxSpeed(4.3);
        new BukkitRunnable(){

            public void run() {
                cart.setVelocity(cart.getVelocity().multiply(1.5));
                cart.setDamage(0.0);
                this.cancel();
                DebugUtility.consoleMessage(name);
            }
        }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 0L);
    }
}

