/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.magic.Catalyst;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.airborne.Airborne;
import me.ultra42.ultraskills.utilities.airborne.PlayerLandingEvent;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Parachute
extends Talent {
    private static String name = "Parachute";
    private static String description = "Crouch while falling to slow your fall until you reach the ground. 1 minute cooldown begins when parachuting ends.";
    private static String tree = "Agility";
    private static int requiredLevel = 18;
    private static Material icon = Material.FEATHER;
    private static int slot = 18;

    public Parachute() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Parachute(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler(ignoreCancelled=true)
    private void onSneakToggle(PlayerToggleSneakEvent e) {
        Player p = e.getPlayer();
        if (p.isOnGround()) {
            return;
        }
        if (e.isSneaking() && Parachute.hasAbility(p)) {
            if (!p.isSwimming() && !p.isGliding() && !p.isInWater() && !p.isClimbing() && Airborne.isAirborne((Entity)p) && Catalyst.getBlocksInAir(p) > 8.0 && AbilityManager.isOffCooldown(p, name)) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 300, 1));
                p.playSound(p.getLocation(), Sound.ENTITY_ENDER_DRAGON_FLAP, 1.0f, 1.0f);
                if (p.isGliding()) {
                    p.setGliding(false);
                }
                AbilityManager.putCooldown(p, name, 30000);
            }
        } else if (!e.isSneaking() && e.getPlayer().hasMetadata("sneakpos")) {
            e.getPlayer().removeMetadata("sneakpos", (Plugin)UltraSkills.getPlugin());
        }
    }

    @EventHandler
    private void onPlayerLanding(PlayerLandingEvent e) {
        if (e.getPlayer().hasPotionEffect(PotionEffectType.SLOW_FALLING)) {
            e.getPlayer().removePotionEffect(PotionEffectType.SLOW_FALLING);
        }
    }
}

