/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class MethanePropulsion
extends Talent {
    private static String name = "MethanePropulsion";
    private static String description = "Left click flying with elytra, right clicking air consumes hunger to give momentum";
    private static String tree = "Agility";
    private static int requiredLevel = 44;
    private static Material icon = Material.PIG_SPAWN_EGG;
    private static int slot = 44;

    public MethanePropulsion() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new MethanePropulsion(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    private void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() == Action.LEFT_CLICK_AIR && event.getPlayer().isGliding()) {
            Player p = event.getPlayer();
            int food_level = p.getFoodLevel();
            if ((double)food_level > 1.0) {
                p.setFoodLevel(food_level - 1);
                p.setVelocity(p.getEyeLocation().getDirection().normalize().multiply(2.0));
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_BURP, 1.0f, 1.0f);
                p.playSound(p.getLocation(), Sound.ENTITY_DRAGON_FIREBALL_EXPLODE, 1.0f, 1.0f);
            } else {
                p.playSound(p.getLocation(), Sound.ENTITY_PLAYER_BREATH, 1.0f, 1.0f);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onBlockBreak(BlockBreakEvent event) {
        if (event.getPlayer().isGliding() && event.getPlayer().getInventory().getItemInMainHand().getType() == Material.AIR) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player p = (Player)event.getDamager();
        if (p.isGliding() && p.getInventory().getItemInMainHand().getType() == Material.AIR) {
            event.setCancelled(true);
        }
    }
}

