/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class HydroPlane
extends Talent {
    private static String name = "HydroPlane";
    private static String description = "While looking up and moving in a boat, crouching makes you take off into the air; you fly as high as the water is deep beneath you; crouch again to land.";
    private static String tree = "Agility";
    private static int requiredLevel = 36;
    private static Material icon = Material.BAMBOO_RAFT;
    private static int slot = 36;

    public HydroPlane() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new HydroPlane(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onExitBoat(VehicleExitEvent e) {
        if (!(e.getVehicle() instanceof Boat) || !(e.getExited() instanceof Player)) {
            return;
        }
        final Boat boat = (Boat)e.getVehicle();
        final Player p = (Player)e.getExited();
        if (boat.isOnGround()) {
            return;
        }
        if (boat.isInWater() && Math.abs(p.getVelocity().getX()) + Math.abs(p.getVelocity().getZ()) == 0.0) {
            return;
        }
        e.setCancelled(true);
        if (boat.isInWater() && !boat.isUnderWater() && AbilityManager.isOffCooldown(p, name) && this.lookingAboveHorizon(p)) {
            boat.setGravity(false);
            AbilityManager.putCooldown(p, name, 1000);
            p.playSound(p.getLocation(), Sound.ENTITY_BOAT_PADDLE_WATER, 0.25f, 4.0f);
            new BukkitRunnable(){

                public void run() {
                    if (boat.isDead() || boat.hasGravity() || boat.getPassengers().isEmpty()) {
                        this.cancel();
                    }
                    double water_level = HydroPlane.this.findBlockBeneathPlayer(p).getY();
                    double height = HydroPlane.this.countConsecutiveWaterBlocks(HydroPlane.this.findBlockBeneathPlayer(p));
                    HydroPlane.this.setBoatVelocity(boat, water_level + height);
                    p.playSound(boat.getLocation(), Sound.ENTITY_PARROT_FLY, 0.25f, 1.0f);
                    DebugUtility.consoleMessage(name);
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 1L, 1L);
        } else if (!boat.isInWater() && !boat.isUnderWater() && AbilityManager.isOffCooldown(p, name)) {
            boat.setGravity(true);
        }
    }

    @EventHandler
    public void onBoatMove(PlayerMoveEvent e) {
        Player p = e.getPlayer();
        if (!HydroPlane.hasAbility(p)) {
            return;
        }
        if (!p.isInsideVehicle()) {
            return;
        }
        Boat boat = (Boat)p.getVehicle();
        assert (boat != null);
        if (boat.isOnGround() && !boat.isUnderWater()) {
            boat.setGravity(true);
            return;
        }
    }

    public void setBoatVelocity(Boat boat, double yLevel) {
        Location boatLocation = boat.getLocation();
        Vector boatVelocity = boat.getLocation().getDirection().normalize();
        double distance = yLevel - boatLocation.getY();
        boatVelocity.setY(distance / 80.0);
        boat.setVelocity(boatVelocity);
    }

    public Block findBlockBeneathPlayer(Player player) {
        Location playerLocation = player.getEyeLocation();
        Block block = playerLocation.getBlock().getRelative(BlockFace.DOWN);
        while (block.getType() == Material.AIR) {
            block = block.getRelative(BlockFace.DOWN);
        }
        return block;
    }

    public int countConsecutiveWaterBlocks(Block block) {
        int count = 0;
        if (block.getType().equals((Object)Material.WATER)) {
            ++count;
        }
        Block currentBlock = block.getRelative(BlockFace.DOWN);
        while (currentBlock.getType() == Material.WATER) {
            ++count;
            currentBlock = currentBlock.getRelative(BlockFace.DOWN);
        }
        return count;
    }

    public boolean lookingAboveHorizon(Player p) {
        Vector playerDirection = p.getEyeLocation().getDirection();
        double horizonAngle = Math.atan2(playerDirection.getY(), Math.sqrt(Math.pow(playerDirection.getX(), 2.0) + Math.pow(playerDirection.getZ(), 2.0)));
        return horizonAngle > 0.0;
    }
}

