/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;

public class Grindset
extends Talent {
    private static String name = "Grindset";
    private static String description = "Crouching on top of fences initiates a rail grind. Crouch or jump to dismount.";
    private static String tree = "Agility";
    private static int requiredLevel = 10;
    private static Material icon = Material.POWERED_RAIL;
    private static int slot = 10;

    public Grindset() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Grindset(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerCrouch(PlayerToggleSneakEvent event) {
        Player p = event.getPlayer();
        if (!Grindset.hasAbility(p)) {
            return;
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!Grindset.hasAbility(player)) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        Location location = player.getLocation();
        Block block = (location = location.subtract(0.0, 1.0, 0.0)).getBlock();
        if (!block.getType().name().endsWith("_FENCE") && !block.getType().name().endsWith("_GATE")) {
            return;
        }
        if (PersistentDataUtility.readString((Entity)player, name, "false").equals("true")) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        block = this.getNextRail(player, to, from);
        if (block != null) {
            this.givePlayerMomentum(player, block);
        } else {
            Vector direction = to.toVector().subtract(from.toVector());
            Vector unitDirection = direction.normalize();
            player.setVelocity(unitDirection.multiply(0.5).add(new Vector(0.0, 0.1, 0.0)));
        }
        this.generateParticlesAtPlayerFeet(player, Particle.ELECTRIC_SPARK);
        player.playSound(player.getLocation(), Sound.BLOCK_GRINDSTONE_USE, 0.3f, 0.75f);
    }

    public void givePlayerMomentum(Player player, Block block) {
        Location playerLocation = player.getLocation();
        Location blockLocation = block.getLocation();
        double dx = blockLocation.getX() - playerLocation.getX() + 0.5;
        double dz = blockLocation.getZ() - playerLocation.getZ() + 0.5;
        Vector momentum = Math.abs(dx) > Math.abs(dz) ? new Vector(dx, 0.0, 0.0).normalize().multiply(0.5) : new Vector(0.0, 0.0, dz).normalize().multiply(0.5);
        player.setVelocity(momentum);
    }

    public boolean isFence(Block block) {
        return block.getType().name().endsWith("_FENCE") || block.getType().name().endsWith("_GATE");
    }

    public Block getNextRail(Player p, Location to, Location from) {
        Vector direction = to.toVector().subtract(from.toVector());
        Vector unitDirection = direction.normalize();
        Block below = from.getBlock().getRelative(0, -1, 0);
        Block forward = below.getRelative((int)Math.round(unitDirection.getX()), 0, (int)Math.round(unitDirection.getZ()));
        if (this.isFence(forward)) {
            return forward;
        }
        if (Math.abs(unitDirection.getX()) > Math.abs(unitDirection.getZ())) {
            Block north = below.getRelative(0, 0, -1);
            Block south = below.getRelative(0, 0, 1);
            if (this.isFence(north) && this.isFence(south)) {
                if (p.getLocation().getDirection().getZ() > 0.0) {
                    return south;
                }
                return north;
            }
            if (this.isFence(north)) {
                return north;
            }
            if (this.isFence(south)) {
                return south;
            }
        } else if (Math.abs(unitDirection.getX()) < Math.abs(unitDirection.getZ())) {
            Block east = below.getRelative(1, 0, 0);
            Block west = below.getRelative(-1, 0, 0);
            if (this.isFence(east) && this.isFence(west)) {
                if (p.getLocation().getDirection().getX() > 0.0) {
                    return east;
                }
                return west;
            }
            if (this.isFence(east)) {
                return east;
            }
            if (this.isFence(west)) {
                return west;
            }
        }
        return null;
    }

    public void generateParticlesAtPlayerFeet(Player player, Particle particle) {
        Location location = player.getLocation();
        World world = location.getWorld();
        double x = location.getX();
        double y = location.getY() - 1.0;
        double z = location.getZ();
        world.spawnParticle(particle, x, y, z, 1);
    }
}

