/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitScheduler;

public class FightOrFlight
extends Talent {
    private static String name = "FightOrFlight";
    private static String description = "Upon taking damage from a mob or player, 50% chance to gain either speed or strength for 15 seconds. 60 seconds cooldown.";
    private static String tree = "Agility";
    private static int requiredLevel = 20;
    private static Material icon = Material.COOKED_CHICKEN;
    private static int slot = 20;
    private static int cooldown = 60;

    public FightOrFlight() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new FightOrFlight(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void entityDamageEvent(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if ((e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK || e.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || e.getCause() == EntityDamageEvent.DamageCause.PROJECTILE) && FightOrFlight.hasAbility(p) && AbilityManager.isOffCooldown(p, name)) {
            double roll = Math.random();
            if (roll >= 0.5) {
                p.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 300, 3));
                p.playSound(p.getLocation(), Sound.ENTITY_WOLF_HURT, 1.0f, 1.0f);
            } else {
                p.addPotionEffect(new PotionEffect(PotionEffectType.INCREASE_DAMAGE, 300, 3));
                p.playSound(p.getLocation(), Sound.ENTITY_WOLF_GROWL, 1.0f, 1.0f);
            }
            AbilityManager.putCooldown(p, name, 1000 * cooldown);
            BukkitScheduler scheduler = Bukkit.getScheduler();
            scheduler.runTaskLater((Plugin)UltraSkills.getPlugin(), () -> FightOrFlight.offCooldownNotification(p), 20L * (long)cooldown);
        }
    }

    public static void offCooldownNotification(Player p) {
        p.playSound(p.getLocation(), Sound.ENTITY_WOLF_SHAKE, 10.0f, 4.0f);
    }
}

