/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class EasyWayOut
extends Talent {
    private static String name = "EasyWayOut";
    private static String description = "Falling into the void teleports you to height limit at an equivalent location in the overworld.";
    private static String tree = "Agility";
    private static int requiredLevel = 42;
    private static Material icon = Material.END_PORTAL_FRAME;
    private static int slot = 42;

    public EasyWayOut() {
        super(name, description, tree, requiredLevel);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new EasyWayOut(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void entityDamageEvent(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Player p = (Player)e.getEntity();
        if (e.getCause().equals((Object)EntityDamageEvent.DamageCause.VOID) && AbilityManager.hasAbility(p, "EasyWayOut") && AbilityManager.isOffCooldown(p, "EasyWayOut")) {
            e.setCancelled(true);
            p.sendMessage("Hope you brought a parachute.");
            p.playSound(p.getLocation(), Sound.BLOCK_END_PORTAL_SPAWN, 10.0f, 4.0f);
            Location loc = new Location(Bukkit.getWorld((String)"world"), p.getLocation().getX(), 320.0, p.getLocation().getZ());
            p.teleport(loc);
        }
    }
}

