/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.PersistentDataUtility;
import me.ultra42.ultraskills.utilities.airborne.Airborne;
import me.ultra42.ultraskills.utilities.airborne.PlayerAirborneEvent;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;

public class Dash
extends Talent {
    private static String name = "Dash";
    private static String description = "Beginning a sprint while mid-air makes you dash forward.";
    private static String tree = "Agility";
    private static int requiredLevel = 7;
    private static Material icon = Material.RABBIT_FOOT;
    private static int slot = 7;

    public Dash() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new Dash(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player p = event.getPlayer();
        if (p.isSprinting() && Airborne.isAirborne((Entity)p) && PersistentDataUtility.readString((Entity)p, name, "false").equals("true")) {
            Vector velocity = p.getLocation().getDirection();
            p.setVelocity(new Vector(velocity.getX(), 0.3, velocity.getZ()));
            p.playSound(p.getLocation(), Sound.ENTITY_CAMEL_DASH, 1.0f, 1.0f);
            p.setFoodLevel(p.getFoodLevel() - 1);
            PersistentDataUtility.store(p, name, "false");
        } else if (Airborne.isOnGround((Entity)p)) {
            PersistentDataUtility.store(p, name, "false");
        }
    }

    @EventHandler
    public void PlayerAirborneEvent(PlayerAirborneEvent e) {
        Player p = e.getPlayer();
        if (!Dash.hasAbility(p)) {
            return;
        }
        if (p.isSprinting()) {
            PersistentDataUtility.store(p, name, "false");
        } else {
            PersistentDataUtility.store(p, name, "true");
        }
    }
}

