/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import me.ultra42.ultraskills.UltraSkills;
import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class CloudJump
extends Talent {
    private static String name = "CloudJump";
    private static String description = "Jump again while in the air. Consumes 1 hunger. If wearing an elytra, ";
    private static String tree = "Agility";
    private static int requiredLevel = 42;
    private static Material icon = Material.BIG_DRIPLEAF;
    private static int slot = 42;

    public CloudJump() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new CloudJump(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void PlayerJump(PlayerJumpEvent e) {
        Player p = e.getPlayer();
        if (!CloudJump.hasAbility(p)) {
            return;
        }
        e.getPlayer().setAllowFlight(true);
    }

    @EventHandler
    public void flightAttempt(PlayerToggleFlightEvent e) {
        Player p = e.getPlayer();
        if (!CloudJump.hasAbility(p)) {
            if (p.getAllowFlight() && p.getGameMode() != GameMode.CREATIVE) {
                p.setAllowFlight(false);
                e.setCancelled(true);
            }
            return;
        }
        e.setCancelled(true);
        p.setAllowFlight(false);
        p.setFlying(false);
        p.setVelocity(e.getPlayer().getLocation().getDirection().multiply(0.5).setY(0.5));
        p.playSound(p.getLocation(), Sound.ENTITY_PHANTOM_FLAP, 1.0f, 1.0f);
        p.setFoodLevel(p.getFoodLevel() - 1);
        p.setAllowFlight(true);
        this.generateHalo(p.getLocation(), p.getWorld());
    }

    @EventHandler
    public void onFallNearGround(PlayerMoveEvent e) {
        final Player p = e.getPlayer();
        if (!CloudJump.hasAbility(p)) {
            return;
        }
        Vector direction = e.getTo().toVector().subtract(e.getFrom().toVector());
        if (p.getAllowFlight() && direction.getY() < -0.05 && !p.getLocation().add(direction.multiply(2)).getBlock().isPassable()) {
            p.setAllowFlight(false);
            new BukkitRunnable(){

                public void run() {
                    DebugUtility.consoleMessage(p.getName() + " used " + name, 4);
                    p.setAllowFlight(true);
                    this.cancel();
                }
            }.runTaskTimer((Plugin)UltraSkills.getPlugin(), 5L, 1L);
        }
    }

    public void generateHalo(Location loc, World world) {
        for (double y = 0.0; y <= Math.PI * 2; y += 0.39269908169872414) {
            double x = Math.cos(y);
            double z = Math.sin(y);
            world.spawnParticle(Particle.CLOUD, loc.getX() + x, loc.getY(), loc.getZ() + z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

