/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities.agility;

import me.ultra42.ultraskills.abilities.SkillMeta;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.utilities.AbilityManager;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class AllOrNothing
extends Talent {
    private static String name = "AllOrNothing";
    private static String description = "If a fall wouldn't kill you, take no damage.";
    private static String tree = "Agility";
    private static int requiredLevel = 30;
    private static Material icon = Material.ANVIL;
    private static int slot = 30;

    public AllOrNothing() {
        super(name, description, tree, requiredLevel);
    }

    public static boolean hasAbility(Player p) {
        return AbilityManager.hasAbility(p, name);
    }

    @Override
    public void register(Plugin p, PluginManager m) {
        m.registerEvents((Listener)new AllOrNothing(), p);
        SkillMeta.setMeta(name, description, tree, requiredLevel, icon, slot);
    }

    @EventHandler
    public void entityDamageEvent(EntityDamageEvent e) {
        if (e.isCancelled()) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (e.getCause() == EntityDamageEvent.DamageCause.FALL && AllOrNothing.hasAbility(p) && e.getFinalDamage() < p.getHealth()) {
            e.setCancelled(true);
            p.setFireTicks(0);
        }
    }
}

