/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills.abilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;

public class SkillMeta {
    private static HashMap<String, String> descriptions = new HashMap();
    private static HashMap<String, String> trees = new HashMap();
    private static HashMap<String, Integer> requiredLevels = new HashMap();
    private static HashMap<String, Material> icons = new HashMap();
    private static HashMap<String, Integer> slots = new HashMap();

    public SkillMeta(String name, int slot) {
    }

    public static void setMeta(String name, String description, String tree, int requiredLevel, Material icon, int slot) {
        descriptions.put(name, description);
        trees.put(name, tree);
        requiredLevels.put(name, requiredLevel);
        icons.put(name, icon);
        slots.put(name, slot);
    }

    public static HashMap<String, String> getAllItemsByTree() {
        return trees;
    }

    public static List<String> getSkillBySlot(int slot, String tree) {
        String name = " ";
        ArrayList<String> names = new ArrayList<String>();
        SkillMeta.getAllItemsByTree().forEach((key, value) -> {
            if (Objects.equals(value, tree) && SkillMeta.getSlot(key) == slot) {
                names.add((String)key);
            }
        });
        return names;
    }

    public static Component getNameComponent(String key) {
        return Component.text((String)key).color(SkillMeta.getTextColor(key));
    }

    public static String getDescription(String key) {
        return descriptions.get(key);
    }

    public static ArrayList<Component> getDescriptionComponent(String key) {
        TextColor c = SkillMeta.getTextColor(key);
        return SkillMeta.formatDescription(SkillMeta.getDescription(key), 32, c);
    }

    private static ArrayList<Component> formatDescription(String text, int maxLength, TextColor c) {
        ArrayList<Component> result = new ArrayList<Component>();
        String[] words = text.split(" ");
        Object currentLine = "";
        for (int i = 0; i < words.length; ++i) {
            if (((String)currentLine).length() + words[i].length() <= maxLength) {
                currentLine = (String)currentLine + words[i] + " ";
                continue;
            }
            result.add(Component.text((String)currentLine).color(c));
            currentLine = words[i] + " ";
        }
        result.add(Component.text((String)currentLine).color(c));
        return result;
    }

    public static int getRequiredLevel(String key) {
        return requiredLevels.get(key);
    }

    public static Material getIcon(String key) {
        return icons.get(key);
    }

    public static int getSlot(String key) {
        return slots.get(key);
    }

    public static TextColor getTextColor(String key) {
        String tree;
        return switch (tree = trees.get(key)) {
            case "General" -> NamedTextColor.GRAY;
            case "Mining" -> NamedTextColor.DARK_GRAY;
            case "Farming" -> NamedTextColor.GREEN;
            case "Foraging" -> NamedTextColor.DARK_GREEN;
            case "Agility" -> NamedTextColor.WHITE;
            case "Defense" -> NamedTextColor.BLUE;
            case "Melee" -> NamedTextColor.RED;
            case "Ranged" -> NamedTextColor.GOLD;
            case "Crafting" -> NamedTextColor.AQUA;
            case "Trinkets" -> NamedTextColor.YELLOW;
            case "Magic" -> NamedTextColor.LIGHT_PURPLE;
            case "Games" -> NamedTextColor.DARK_PURPLE;
            default -> NamedTextColor.BLACK;
        };
    }
}

