/*
 * Decompiled with CFR 0.152.
 */
package me.ultra42.ultraskills;

import java.util.HashMap;
import me.ultra42.ultraskills.abilities.Talent;
import me.ultra42.ultraskills.abilities.farming.Pesticides;
import me.ultra42.ultraskills.commands.SetLevel;
import me.ultra42.ultraskills.commands.SetXP;
import me.ultra42.ultraskills.commands.SkillMenuCommand;
import me.ultra42.ultraskills.effects.Effect;
import me.ultra42.ultraskills.menusystem.MenuListener;
import me.ultra42.ultraskills.menusystem.PlayerMenuUtility;
import me.ultra42.ultraskills.menusystem.XPBossBars;
import me.ultra42.ultraskills.skillgroups.SkillGroup;
import me.ultra42.ultraskills.tools.Tool;
import me.ultra42.ultraskills.utilities.AbilityManager;
import me.ultra42.ultraskills.utilities.DataManager;
import me.ultra42.ultraskills.utilities.DebugUtility;
import me.ultra42.ultraskills.utilities.UpdateChecker;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class UltraSkills
extends JavaPlugin {
    private static UltraSkills plugin;
    public static DataManager data;
    private static final HashMap<Player, PlayerMenuUtility> playerMenuUtilityMap;

    public void onEnable() {
        plugin = this;
        data = new DataManager(this);
        this.saveDefaultConfig();
        UpdateChecker updateChecker = new UpdateChecker();
        updateChecker.check();
        this.getServer().getPluginManager().registerEvents((Listener)updateChecker, (Plugin)this);
        Pesticides p = new Pesticides();
        DebugUtility.consoleMessage(SkillGroup.getSkillColor(p.getTree()).asHexString(), 4);
        this.getCommand("setxp").setExecutor((CommandExecutor)new SetXP());
        this.getCommand("setlevel").setExecutor((CommandExecutor)new SetLevel());
        this.getCommand("skills").setExecutor((CommandExecutor)new SkillMenuCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(), (Plugin)this);
        String packageName = ((Object)((Object)this)).getClass().getPackage().getName();
        this.getLogger().info("Successfully loaded " + Effect.registerEffects(packageName) + " effects. (reflection)");
        this.getLogger().info("Successfully loaded " + Tool.registerTools(packageName) + " tools. (reflection)");
        this.getLogger().info("Successfully loaded " + SkillGroup.registerSkillGroups(packageName) + " skill groups. (reflection)");
        this.getLogger().info("Successfully loaded " + Talent.registerSkills(packageName) + " skills. (reflection)");
    }

    public void onDisable() {
        this.getLogger().info("Shutting down...");
        AbilityManager.close();
        XPBossBars.close();
    }

    public static UltraSkills getPlugin() {
        return plugin;
    }

    public static DataManager getData() {
        return data;
    }

    public static PlayerMenuUtility getPlayerMenuUtility(Player p) {
        if (playerMenuUtilityMap.containsKey(p)) {
            return playerMenuUtilityMap.get(p);
        }
        PlayerMenuUtility playerMenuUtility = new PlayerMenuUtility(p);
        playerMenuUtilityMap.put(p, playerMenuUtility);
        return playerMenuUtility;
    }

    public static Component welcomePlayer(Player p) {
        return Component.text((String)"Type /skills to access the skills menu.").color((TextColor)NamedTextColor.GREEN);
    }

    static {
        playerMenuUtilityMap = new HashMap();
    }
}

