/*
 * Decompiled with CFR 0.152.
 */
package tv.ghostvone.moderation.utils;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class Players {
    public static Collection<OfflinePlayer> allOffline() {
        return ImmutableList.copyOf((Object[])Bukkit.getOfflinePlayers());
    }

    public static Collection<Player> allOnline() {
        return Bukkit.getOnlinePlayers();
    }

    public static Collection<BanEntry> allBaned() {
        return Bukkit.getBanList((BanList.Type)BanList.Type.NAME).getBanEntries();
    }

    public static <T> List<T> getPage(List<T> sourceList, int page, int pageSize) {
        if (pageSize <= 0 || page <= 0) {
            throw new IllegalArgumentException("invalid page size: " + pageSize);
        }
        int fromIndex = (page - 1) * pageSize;
        if (sourceList == null || sourceList.size() <= fromIndex) {
            return Collections.emptyList();
        }
        return sourceList.subList(fromIndex, Math.min(fromIndex + pageSize, sourceList.size()));
    }
}

