/*
 * Decompiled with CFR 0.152.
 */
package tv.ghostvone.moderation.manager;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;

public abstract class CustomCommandManager
extends BukkitCommand {
    public CustomCommandManager(String command, String[] aliases, String description, String permission) {
        super(command);
        if (aliases != null) {
            this.setAliases(Arrays.asList(aliases));
        }
        this.setDescription(description);
        this.setPermission(permission);
        this.setPermissionMessage(ChatColor.RED + "You must have " + permission + " to use this command");
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            CommandMap map = (CommandMap)field.get(Bukkit.getServer());
            map.register(command, (Command)this);
        }
        catch (IllegalAccessException | NoSuchFieldException exception) {
            exception.printStackTrace();
        }
    }

    public boolean execute(CommandSender commandSender, String s, String[] strings) {
        this.execute(commandSender, strings);
        return false;
    }

    public abstract void execute(CommandSender var1, String[] var2);

    public List<String> tabComplete(CommandSender sender, String alias, String[] args) throws IllegalArgumentException {
        return this.onTabComplete(sender, args);
    }

    public abstract List<String> onTabComplete(CommandSender var1, String[] var2);
}

