/*
 * Decompiled with CFR 0.152.
 */
package tv.ghostvone.moderation.gui;

import com.github.stefvanschie.inventoryframework.font.util.Font;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.component.Label;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.bukkit.BanEntry;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.StringUtil;
import tv.ghostvone.moderation.Moderation;
import tv.ghostvone.moderation.gui.PlayerView;
import tv.ghostvone.moderation.lang.LangList;
import tv.ghostvone.moderation.utils.Players;

public class PlayersView {
    private Moderation moderation;
    private final Integer amountPlayerDisplayed = 45;
    private Integer pageAmount;
    private Integer page = 1;
    private String playersFilterType = "online";
    private Player player;
    private String searchValue = "";
    PlayerView playerView;

    public PlayersView(Moderation moderation, Player player) {
        this.moderation = moderation;
        this.player = player;
        this.playerView = new PlayerView(this);
        this.openGUI();
    }

    public void openGUI() {
        Gui gui = null;
        OutlinePane playersListPane = new OutlinePane(0, 1, 9, 6);
        block5 : switch (this.playersFilterType) {
            case "online": {
                Collection<Player> onlinePlayers = Players.allOnline();
                this.pageAmount = (int)Math.ceil((float)onlinePlayers.size() / (float)this.amountPlayerDisplayed.intValue());
                this.pageAmount = this.pageAmount == 0 ? 1 : this.pageAmount;
                gui = new ChestGui(6, this.moderation.getLangManager().getMessage(LangList.ONLINE_PLAYERS) + " (" + this.page + "/" + this.pageAmount + ")");
                for (Player pplayer : Players.getPage(new ArrayList<Player>(onlinePlayers), this.page, this.amountPlayerDisplayed)) {
                    ItemStack pplayerHead = new ItemStack(Material.PLAYER_HEAD);
                    ItemMeta pplayerHeadMeta = pplayerHead.getItemMeta();
                    pplayerHeadMeta.setDisplayName(pplayer.getName());
                    pplayerHead.setItemMeta(pplayerHeadMeta);
                    playersListPane.addItem(new GuiItem(pplayerHead, event -> this.playerView.openGUI(Bukkit.getOfflinePlayer((String)event.getCurrentItem().getItemMeta().getDisplayName()))));
                }
                break;
            }
            case "offline": {
                Collection<OfflinePlayer> offlinePlayers = Players.allOffline();
                this.pageAmount = (int)Math.ceil((float)offlinePlayers.size() / (float)this.amountPlayerDisplayed.intValue());
                this.pageAmount = this.pageAmount == 0 ? 1 : this.pageAmount;
                gui = new ChestGui(6, this.moderation.getLangManager().getMessage(LangList.ALL_PLAYERS) + " (" + this.page + "/" + this.pageAmount + ")");
                Integer loop = 0;
                for (OfflinePlayer pplayer : Players.getPage(new ArrayList<OfflinePlayer>(offlinePlayers), this.page, this.amountPlayerDisplayed)) {
                    if (loop == this.amountPlayerDisplayed) break block5;
                    ItemStack pplayerHead = new ItemStack(Material.PLAYER_HEAD);
                    ItemMeta pplayerHeadMeta = pplayerHead.getItemMeta();
                    pplayerHeadMeta.setDisplayName(pplayer.getName());
                    pplayerHead.setItemMeta(pplayerHeadMeta);
                    playersListPane.addItem(new GuiItem(pplayerHead, event -> this.playerView.openGUI(Bukkit.getOfflinePlayer((String)event.getCurrentItem().getItemMeta().getDisplayName()))));
                    Integer n = loop;
                    loop = loop + 1;
                }
                break;
            }
            case "banned": {
                Collection<BanEntry> bannedPlayers = Players.allBaned();
                this.pageAmount = (int)Math.ceil((float)bannedPlayers.size() / (float)this.amountPlayerDisplayed.intValue());
                this.pageAmount = this.pageAmount == 0 ? 1 : this.pageAmount;
                gui = new ChestGui(6, this.moderation.getLangManager().getMessage(LangList.BANNED_PLAYERS) + " (" + this.page + "/" + this.pageAmount + ")");
                for (BanEntry pplayer : Players.getPage(new ArrayList<BanEntry>(bannedPlayers), this.page, this.amountPlayerDisplayed)) {
                    ItemStack pplayerHead = new ItemStack(Material.PLAYER_HEAD);
                    ItemMeta pplayerHeadMeta = pplayerHead.getItemMeta();
                    pplayerHeadMeta.setDisplayName(pplayer.getTarget());
                    pplayerHead.setItemMeta(pplayerHeadMeta);
                    playersListPane.addItem(new GuiItem(pplayerHead, event -> this.playerView.openGUI(Bukkit.getOfflinePlayer((String)event.getCurrentItem().getItemMeta().getDisplayName()))));
                }
                break;
            }
        }
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        ((ChestGui)gui).addPane(playersListPane);
        OutlinePane background = new OutlinePane(0, 0, 9, 6, Pane.Priority.LOWEST);
        ItemStack disabledSlot = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta disabledSlotmeta = disabledSlot.getItemMeta();
        disabledSlotmeta.setDisplayName(ChatColor.RED + "");
        disabledSlot.setItemMeta(disabledSlotmeta);
        background.addItem(new GuiItem(disabledSlot));
        background.setRepeat(true);
        ((ChestGui)gui).addPane(background);
        OutlinePane topPane = new OutlinePane(2, 0, 5, 1);
        OutlinePane backPane = new OutlinePane(0, 0, 1, 1);
        OutlinePane nextPane = new OutlinePane(8, 0, 1, 1);
        ItemStack leftArrowButton = PlayersView.getCustomHeadItem(this.moderation.getLangManager().getMessage(LangList.PREVIOUS_PAGE), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvY2RjOWU0ZGNmYTQyMjFhMWZhZGMxYjViMmIxMWQ4YmVlYjU3ODc5YWYxYzQyMzYyMTQyYmFlMWVkZDUifX19");
        backPane.addItem(new GuiItem(leftArrowButton, event -> {
            if (this.page == 1) {
                return;
            }
            this.page = this.page == 1 ? 1 : this.page - 1;
            this.openGUI();
        }));
        ItemStack onlinePlayersButton = PlayersView.getCustomHeadItem(this.moderation.getLangManager().getMessage(LangList.SHOW_ONLINE_PLAYERS), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDI3Y2E0NmY2YTliYjg5YTI0ZmNhZjRjYzBhY2Y1ZTgyODVhNjZkYjc1MjEzNzhlZDI5MDlhZTQ0OTY5N2YifX19");
        topPane.addItem(new GuiItem(onlinePlayersButton, event -> {
            this.moderation.setShowOnlinePlayers(true);
            this.playersFilterType = "online";
            this.page = 1;
            this.openGUI();
        }));
        ItemStack offlinePlayersButton = PlayersView.getCustomHeadItem(this.moderation.getLangManager().getMessage(LangList.SHOW_ALL_PLAYERS), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODNkMWM0NjM3NTZjYTMzYzlkNmNlYmQyNDIzNzk1ZDhhNGQ4N2U3MTk0YjUwMzU3OWU4ZTExMjI1MTY2ZmUifX19");
        topPane.addItem(new GuiItem(offlinePlayersButton, event -> {
            this.moderation.setShowOnlinePlayers(false);
            this.playersFilterType = "offline";
            this.page = 1;
            this.openGUI();
        }));
        ItemStack banListButton = PlayersView.getCustomHeadItem(this.moderation.getLangManager().getMessage(LangList.SHOW_BANNED_PLAYERS), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZkZTNiZmNlMmQ4Y2I3MjRkZTg1NTZlNWVjMjFiN2YxNWY1ODQ2ODRhYjc4NTIxNGFkZDE2NGJlNzYyNGIifX19");
        topPane.addItem(new GuiItem(banListButton, event -> {
            this.playersFilterType = "banned";
            this.page = 1;
            this.openGUI();
        }));
        ItemStack airButton = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta airButtonMeta = disabledSlot.getItemMeta();
        airButtonMeta.setDisplayName(ChatColor.RED + "");
        airButton.setItemMeta(airButtonMeta);
        topPane.addItem(new GuiItem(airButton));
        ItemStack searchButton = new ItemStack(Material.SPYGLASS);
        ItemMeta searchButtonMeta = searchButton.getItemMeta();
        searchButtonMeta.setDisplayName("Search player");
        searchButton.setItemMeta(searchButtonMeta);
        topPane.addItem(new GuiItem(searchButton, event -> this.openSearchGUI()));
        ItemStack rightArrowButton = PlayersView.getCustomHeadItem(this.moderation.getLangManager().getMessage(LangList.NEXT_PAGE), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTU2YTM2MTg0NTllNDNiMjg3YjIyYjdlMjM1ZWM2OTk1OTQ1NDZjNmZjZDZkYzg0YmZjYTRjZjMwYWI5MzExIn19fQ==");
        nextPane.addItem(new GuiItem(rightArrowButton, event -> {
            if (this.pageAmount == this.page) {
                return;
            }
            this.page = this.page + 1;
            this.openGUI();
        }));
        ((ChestGui)gui).addPane(nextPane);
        ((ChestGui)gui).addPane(backPane);
        ((ChestGui)gui).addPane(topPane);
        ((ChestGui)gui).show((HumanEntity)this.player);
    }

    private void displayAlpha(ChestGui gui, OutlinePane searchValuePane, List<String> names) {
        gui.getPanes().clear();
        OutlinePane topPane = new OutlinePane(4, 0, 1, 1);
        ItemStack cancelButton = new ItemStack(Material.BARRIER);
        ItemMeta cancelButtonMeta = cancelButton.getItemMeta();
        cancelButtonMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.BACK));
        cancelButton.setItemMeta(cancelButtonMeta);
        topPane.addItem(new GuiItem(cancelButton, event -> {
            this.searchValue = "";
            this.openGUI();
        }));
        gui.addPane(topPane);
        Label displayNumbers = new Label(2, 0, 1, 1, Font.WHITE);
        displayNumbers.setText("#");
        displayNumbers.setOnClick(inventoryClickEvent -> {
            this.displayNumbers(gui, searchValuePane, names);
            this.updateSearch(searchValuePane, names, gui);
        });
        ItemStack numberPane = ((GuiItem)displayNumbers.getItems().get(0)).getItem();
        ItemMeta numberPaneMeta = numberPane.getItemMeta();
        numberPaneMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.DISPLAY_NUMBER));
        numberPane.setItemMeta(numberPaneMeta);
        gui.addPane(displayNumbers);
        Label delLabel = new Label(6, 0, 1, 1, Font.WHITE);
        delLabel.setText("\u23f4");
        delLabel.setOnClick(inventoryClickEvent -> {
            this.searchValue = this.searchValue.substring(0, this.searchValue.length() - 1);
            this.updateSearch(searchValuePane, names, gui);
        });
        ItemStack delItem = ((GuiItem)delLabel.getItems().get(0)).getItem();
        ItemMeta delMeta = delItem.getItemMeta();
        delMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.DEL));
        delItem.setItemMeta(delMeta);
        gui.addPane(delLabel);
        Label delAllLabel = new Label(7, 0, 1, 1, Font.WHITE);
        delAllLabel.setText("\u23ea");
        delAllLabel.setOnClick(inventoryClickEvent -> {
            this.searchValue = "";
            this.updateSearch(searchValuePane, names, gui);
        });
        ItemStack delAllItem = ((GuiItem)delAllLabel.getItems().get(0)).getItem();
        ItemMeta delAllMeta = delAllItem.getItemMeta();
        delAllMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.RESET));
        delAllItem.setItemMeta(delAllMeta);
        gui.addPane(delAllLabel);
        Integer alphabetCount = 0;
        for (char alphabet = 'a'; alphabet <= 'z'; alphabet = (char)(alphabet + '\u0001')) {
            StringBuilder sb = new StringBuilder();
            sb.append(alphabet);
            Label alphabetLetter = new Label(alphabetCount % 9, alphabetCount / 9 + 3, 1, 1, Font.WHITE);
            alphabetLetter.setText(sb.toString().toUpperCase());
            alphabetLetter.setOnClick(inventoryClickEvent -> {
                inventoryClickEvent.setCancelled(true);
                this.searchValue = this.searchValue + inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
                this.updateSearch(searchValuePane, names, gui);
            });
            ItemStack letter = ((GuiItem)alphabetLetter.getItems().get(0)).getItem();
            ItemMeta letterMeta = letter.getItemMeta();
            letterMeta.setDisplayName(sb.toString().toUpperCase());
            letter.setItemMeta(letterMeta);
            Integer n = alphabetCount;
            alphabetCount = alphabetCount + 1;
            gui.addPane(alphabetLetter);
        }
        gui.update();
    }

    private void displayNumbers(ChestGui gui, OutlinePane searchValuePane, List<String> names) {
        gui.getPanes().clear();
        OutlinePane topPane = new OutlinePane(4, 0, 1, 1);
        ItemStack cancelButton = new ItemStack(Material.BARRIER);
        ItemMeta cancelButtonMeta = cancelButton.getItemMeta();
        cancelButtonMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.BACK));
        cancelButton.setItemMeta(cancelButtonMeta);
        topPane.addItem(new GuiItem(cancelButton, event -> {
            this.searchValue = "";
            this.openGUI();
        }));
        gui.addPane(topPane);
        Label displayNumbers = new Label(2, 0, 1, 1, Font.WHITE);
        displayNumbers.setText("A");
        displayNumbers.setOnClick(inventoryClickEvent -> {
            this.displayAlpha(gui, searchValuePane, names);
            this.updateSearch(searchValuePane, names, gui);
        });
        ItemStack numberPane = ((GuiItem)displayNumbers.getItems().get(0)).getItem();
        ItemMeta numberPaneMeta = numberPane.getItemMeta();
        numberPaneMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.DISPLAY_ALPHABET));
        numberPane.setItemMeta(numberPaneMeta);
        gui.addPane(displayNumbers);
        Label delLabel = new Label(6, 0, 1, 1, Font.WHITE);
        delLabel.setText("\u23f4");
        delLabel.setOnClick(inventoryClickEvent -> {
            this.searchValue = this.searchValue.substring(0, this.searchValue.length() - 1);
            this.updateSearch(searchValuePane, names, gui);
        });
        ItemStack delItem = ((GuiItem)delLabel.getItems().get(0)).getItem();
        ItemMeta delMeta = delItem.getItemMeta();
        delMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.DEL));
        delItem.setItemMeta(delMeta);
        gui.addPane(delLabel);
        Label delAllLabel = new Label(7, 0, 1, 1, Font.WHITE);
        delAllLabel.setText("\u23ea");
        delAllLabel.setOnClick(inventoryClickEvent -> {
            this.searchValue = "";
            this.updateSearch(searchValuePane, names, gui);
        });
        ItemStack delAllItem = ((GuiItem)delAllLabel.getItems().get(0)).getItem();
        ItemMeta delAllMeta = delAllItem.getItemMeta();
        delAllMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.RESET));
        delAllItem.setItemMeta(delAllMeta);
        gui.addPane(delAllLabel);
        Integer numberCount = 0;
        while (numberCount < 5) {
            Object alphabetLetter = new Label(numberCount + 2, 4, 1, 1, Font.WHITE);
            ((Label)alphabetLetter).setText(numberCount + "");
            ((Pane)alphabetLetter).setOnClick(inventoryClickEvent -> {
                inventoryClickEvent.setCancelled(true);
                this.searchValue = this.searchValue + inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
                this.updateSearch(searchValuePane, names, gui);
            });
            ItemStack letter = ((GuiItem)((OutlinePane)alphabetLetter).getItems().get(0)).getItem();
            ItemMeta letterMeta = letter.getItemMeta();
            letterMeta.setDisplayName(numberCount + "");
            letter.setItemMeta(letterMeta);
            gui.addPane((Pane)alphabetLetter);
            Label alphabetLetter2 = new Label(numberCount + 2, 5, 1, 1, Font.WHITE);
            alphabetLetter2.setText(numberCount + 5 + "");
            alphabetLetter2.setOnClick(inventoryClickEvent -> {
                inventoryClickEvent.setCancelled(true);
                this.searchValue = this.searchValue + inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
                this.updateSearch(searchValuePane, names, gui);
            });
            ItemStack letter2 = ((GuiItem)((OutlinePane)alphabetLetter).getItems().get(0)).getItem();
            ItemMeta letterMeta2 = letter2.getItemMeta();
            letterMeta2.setDisplayName(numberCount + "");
            letter2.setItemMeta(letterMeta2);
            gui.addPane(alphabetLetter2);
            alphabetLetter = numberCount;
            numberCount = numberCount + 1;
        }
        Label underscore = new Label(8, 5, 1, 1, Font.WHITE);
        underscore.setText("_");
        underscore.setOnClick(inventoryClickEvent -> {
            inventoryClickEvent.setCancelled(true);
            this.searchValue = this.searchValue + inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName();
            this.updateSearch(searchValuePane, names, gui);
        });
        ItemStack underscoreLetter = ((GuiItem)underscore.getItems().get(0)).getItem();
        ItemMeta underscoreLetterMeta = underscoreLetter.getItemMeta();
        underscoreLetterMeta.setDisplayName("_");
        underscoreLetter.setItemMeta(underscoreLetterMeta);
        gui.addPane(underscore);
        gui.update();
    }

    private void openSearchGUI() {
        ChestGui gui = new ChestGui(6, "Search : ");
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        ArrayList<String> names = new ArrayList<String>();
        for (OfflinePlayer player : Bukkit.getOfflinePlayers()) {
            names.add(player.getName());
        }
        OutlinePane searchValuePane = new OutlinePane(0, 1, 9, 2);
        this.displayAlpha(gui, searchValuePane, names);
        OutlinePane background = new OutlinePane(0, 0, 9, 6, Pane.Priority.LOWEST);
        ItemStack disabledSlot = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta disabledSlotmeta = disabledSlot.getItemMeta();
        disabledSlotmeta.setDisplayName(ChatColor.RED + "");
        disabledSlot.setItemMeta(disabledSlotmeta);
        background.addItem(new GuiItem(disabledSlot));
        background.setRepeat(true);
        gui.show((HumanEntity)this.player);
    }

    private void updateSearch(OutlinePane searchValuePane, List<String> names, ChestGui gui) {
        searchValuePane.clear();
        if (this.searchValue != "") {
            List namesValues = (List)StringUtil.copyPartialMatches((String)this.searchValue, names, new ArrayList());
            for (String nameValue : namesValues) {
                ItemStack pplayerHead = new ItemStack(Material.PLAYER_HEAD);
                ItemMeta pplayerHeadMeta = pplayerHead.getItemMeta();
                pplayerHeadMeta.setDisplayName(nameValue);
                pplayerHead.setItemMeta(pplayerHeadMeta);
                searchValuePane.addItem(new GuiItem(pplayerHead, eventt -> this.playerView.openGUI(Bukkit.getOfflinePlayer((String)eventt.getCurrentItem().getItemMeta().getDisplayName()))));
            }
        }
        gui.addPane(searchValuePane);
        gui.setTitle("Search : " + this.searchValue);
        gui.update();
    }

    static ItemStack getCustomHeadItem(String itemName, String headValue) {
        ItemStack itemStack = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(itemName);
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), null);
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", headValue));
        try {
            Field field = itemMeta.getClass().getDeclaredField("profile");
            field.setAccessible(true);
            field.set(itemMeta, gameProfile);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public Moderation getModeration() {
        return this.moderation;
    }

    public Integer getAmountPlayerDisplayed() {
        return this.amountPlayerDisplayed;
    }

    public Integer getPageAmount() {
        return this.pageAmount;
    }

    public Integer getPage() {
        return this.page;
    }

    public String getPlayersFilterType() {
        return this.playersFilterType;
    }

    public Player getPlayer() {
        return this.player;
    }
}

