/*
 * Decompiled with CFR 0.152.
 */
package tv.ghostvone.moderation.gui;

import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.type.AnvilGui;
import com.github.stefvanschie.inventoryframework.gui.type.ChestGui;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.StaticPane;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import tv.ghostvone.moderation.Moderation;
import tv.ghostvone.moderation.gui.PlayersView;
import tv.ghostvone.moderation.lang.LangList;
import tv.ghostvone.moderation.permission.Permission;

public class PlayerView {
    Moderation moderation;
    PlayersView playersView;

    public PlayerView(PlayersView playersView) {
        this.moderation = playersView.getModeration();
        this.playersView = playersView;
    }

    public void openGUI(OfflinePlayer target) {
        ItemMeta banHeadMeta;
        ItemStack banHead;
        ChestGui gui = new ChestGui(6, target.getName());
        gui.setOnGlobalClick(event -> event.setCancelled(true));
        OutlinePane topPane = new OutlinePane(0, 0, 9, 1);
        OutlinePane navigationPane = new OutlinePane(0, 1, 9, 6);
        ItemStack cancelButton = new ItemStack(Material.BARRIER);
        ItemMeta cancelButtonMeta = cancelButton.getItemMeta();
        cancelButtonMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.BACK));
        cancelButton.setItemMeta(cancelButtonMeta);
        topPane.addItem(new GuiItem(cancelButton, event -> this.playersView.openGUI()));
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta playerHeadMeta = playerHead.getItemMeta();
        playerHeadMeta.setDisplayName(target.getName());
        playerHead.setItemMeta(playerHeadMeta);
        navigationPane.addItem(new GuiItem(playerHead));
        if (target.isOnline()) {
            ItemStack kickHead = new ItemStack(Material.OAK_DOOR);
            ItemMeta kickHeadMeta = kickHead.getItemMeta();
            kickHeadMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.KICK));
            kickHead.setItemMeta(kickHeadMeta);
            navigationPane.addItem(new GuiItem(kickHead, event -> {
                if (!this.playersView.getPlayer().hasPermission(Permission.KICK_PLAYER.getName())) {
                    this.playersView.getPlayer().sendMessage(ChatColor.RED + "You need the permission (" + Permission.KICK_PLAYER.getName() + ") to use this command");
                    return;
                }
                target.getPlayer().kickPlayer(this.moderation.getLangManager().getMessage(LangList.KICK_MESSAGE));
                this.playersView.getPlayer().sendMessage(target.getName() + " " + this.moderation.getLangManager().getMessage(LangList.KICKED_MESSAGE));
                this.playersView.openGUI();
            }));
        }
        if (!target.isBanned()) {
            banHead = new ItemStack(Material.CAMPFIRE);
            banHeadMeta = banHead.getItemMeta();
            banHeadMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.BAN));
            banHead.setItemMeta(banHeadMeta);
            navigationPane.addItem(new GuiItem(banHead, event -> {
                if (!this.playersView.getPlayer().hasPermission(Permission.BAN_PLAYER.getName())) {
                    this.playersView.getPlayer().sendMessage(ChatColor.RED + "You need the permission (" + Permission.BAN_PLAYER.getName() + ") to use this command");
                    return;
                }
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(target.getName(), "", null, null);
                if (target.isOnline()) {
                    target.getPlayer().kickPlayer(ChatColor.RED + this.moderation.getLangManager().getMessage(LangList.BAN_MESSAGE));
                }
                this.playersView.openGUI();
            }));
        }
        if (target.isBanned()) {
            banHead = new ItemStack(Material.CAMPFIRE);
            banHeadMeta = banHead.getItemMeta();
            banHeadMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.UNBAN));
            banHead.setItemMeta(banHeadMeta);
            navigationPane.addItem(new GuiItem(banHead, event -> {
                if (!this.playersView.getPlayer().hasPermission(Permission.UNBAN_PLAYER.getName())) {
                    this.playersView.getPlayer().sendMessage(ChatColor.RED + "You need the permission (" + Permission.UNBAN_PLAYER.getName() + ") to use this command");
                    return;
                }
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).pardon(target.getName());
                this.playersView.getPlayer().sendMessage(target.getName() + " " + this.moderation.getLangManager().getMessage(LangList.UNBANNED_MESSAGE));
                this.playersView.openGUI();
            }));
        }
        OutlinePane background = new OutlinePane(0, 0, 9, 6, Pane.Priority.LOWEST);
        ItemStack disabledSlot = new ItemStack(Material.BLACK_STAINED_GLASS_PANE);
        ItemMeta disabledSlotmeta = disabledSlot.getItemMeta();
        disabledSlotmeta.setDisplayName(ChatColor.RED + "");
        disabledSlot.setItemMeta(disabledSlotmeta);
        background.addItem(new GuiItem(disabledSlot));
        background.setRepeat(true);
        gui.addPane(background);
        gui.addPane(topPane);
        gui.addPane(navigationPane);
        gui.show((HumanEntity)this.playersView.getPlayer());
    }

    public void openBanGUI(OfflinePlayer target) {
        AnvilGui banGUI = new AnvilGui("BAN HAMMER");
        banGUI.setOnGlobalClick(event -> event.setCancelled(true));
        StaticPane backPane = new StaticPane(0, 0, 1, 1);
        ItemStack cancelButton = new ItemStack(Material.BARRIER);
        ItemMeta cancelButtonMeta = cancelButton.getItemMeta();
        cancelButtonMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.BACK));
        cancelButton.setItemMeta(cancelButtonMeta);
        backPane.addItem(new GuiItem(cancelButton, event -> this.openGUI(target)), 0, 0);
        StaticPane confirmPane = new StaticPane(0, 0, 1, 1);
        ItemStack confirmButton = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
        ItemMeta confirmButtonMeta = confirmButton.getItemMeta();
        confirmButtonMeta.setDisplayName(this.moderation.getLangManager().getMessage(LangList.BAN));
        confirmButton.setItemMeta(confirmButtonMeta);
        confirmPane.addItem(new GuiItem(confirmButton, event -> {}), 0, 0);
        banGUI.getSecondItemComponent().addPane(backPane);
        banGUI.getResultComponent().addPane(confirmPane);
        banGUI.show((HumanEntity)this.playersView.getPlayer());
    }
}

