/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.util;

import java.util.AbstractMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class GeometryUtil {
    @NotNull
    @Contract(pure=true)
    public static Map.Entry<Integer, Integer> processClockwiseRotation(int x, int y, int length, int height, int rotation) {
        int newX = x;
        int newY = y;
        if (rotation == 90) {
            newX = height - 1 - y;
            newY = x;
        } else if (rotation == 180) {
            newX = length - 1 - x;
            newY = height - 1 - y;
        } else if (rotation == 270) {
            newX = y;
            newY = length - 1 - x;
        }
        return new AbstractMap.SimpleEntry<Integer, Integer>(newX, newY);
    }

    @NotNull
    @Contract(pure=true)
    public static Map.Entry<Integer, Integer> processCounterClockwiseRotation(int x, int y, int length, int height, int rotation) {
        return GeometryUtil.processClockwiseRotation(x, y, length, height, 360 - rotation);
    }
}

