/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.component;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class ToggleButton
extends Pane {
    private final OutlinePane enabledPane;
    private final OutlinePane disabledPane;
    private boolean enabled = false;

    public ToggleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        this(x, y, length, height);
        this.setPriority(priority);
    }

    public ToggleButton(int x, int y, int length, int height, @NotNull Pane.Priority priority, boolean enabled) {
        this(x, y, length, height, priority);
        this.enabled = enabled;
    }

    public ToggleButton(int length, int height) {
        super(length, height);
        this.enabledPane = new OutlinePane(this.x, this.y, length, height);
        this.enabledPane.addItem(new GuiItem(new ItemStack(Material.GREEN_STAINED_GLASS_PANE)));
        this.enabledPane.setRepeat(true);
        this.disabledPane = new OutlinePane(this.x, this.y, length, height);
        this.disabledPane.addItem(new GuiItem(new ItemStack(Material.RED_STAINED_GLASS_PANE)));
        this.disabledPane.setRepeat(true);
    }

    public ToggleButton(int length, int height, boolean enabled) {
        this(length, height);
        this.enabled = enabled;
    }

    public ToggleButton(int x, int y, int length, int height) {
        this(length, height);
        this.setX(x);
        this.setY(y);
    }

    public ToggleButton(int x, int y, int length, int height, boolean enabled) {
        this(x, y, length, height);
        this.enabled = enabled;
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int newMaxLength = Math.min(maxLength, this.length);
        int newMaxHeight = Math.min(maxHeight, this.height);
        if (this.enabled) {
            this.enabledPane.display(inventoryComponent, paneOffsetX, paneOffsetY, newMaxLength, newMaxHeight);
        } else {
            this.disabledPane.display(inventoryComponent, paneOffsetX, paneOffsetY, newMaxLength, newMaxHeight);
        }
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        int adjustedSlot = slot - (this.getX() + paneOffsetX) - inventoryComponent.getLength() * (this.getY() + paneOffsetY);
        int x = adjustedSlot % inventoryComponent.getLength();
        int y = adjustedSlot / inventoryComponent.getLength();
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.toggle();
        this.callOnClick(event);
        int newX = paneOffsetX + x;
        int newY = paneOffsetY + y;
        if (this.enabled) {
            this.disabledPane.click(gui, inventoryComponent, event, slot, newX, newY, length, height);
        } else {
            this.enabledPane.click(gui, inventoryComponent, event, slot, newX, newY, length, height);
        }
        gui.update();
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public ToggleButton copy() {
        ToggleButton toggleButton = new ToggleButton(this.x, this.y, this.length, this.height, this.getPriority(), this.enabled);
        toggleButton.setVisible(this.isVisible());
        toggleButton.onClick = this.onClick;
        toggleButton.uuid = this.uuid;
        toggleButton.setEnabledItem(((GuiItem)this.enabledPane.getItems().get(0)).copy());
        toggleButton.setDisabledItem(((GuiItem)this.disabledPane.getItems().get(0)).copy());
        return toggleButton;
    }

    @Override
    public void setLength(int length) {
        super.setLength(length);
        this.disabledPane.setLength(length);
        this.enabledPane.setLength(length);
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.disabledPane.setHeight(height);
        this.enabledPane.setHeight(height);
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.disabledPane.setX(x);
        this.enabledPane.setX(x);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.disabledPane.setY(y);
        this.enabledPane.setY(y);
    }

    public void setDisabledItem(@NotNull GuiItem item) {
        this.disabledPane.clear();
        this.disabledPane.addItem(item);
    }

    public void setEnabledItem(@NotNull GuiItem item) {
        this.enabledPane.clear();
        this.enabledPane.addItem(item);
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Collection<Pane> getPanes() {
        return Stream.of(this.enabledPane, this.disabledPane).collect(Collectors.toSet());
    }

    @Contract(pure=true)
    public boolean isEnabled() {
        return this.enabled;
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    @Override
    public void clear() {
    }

    @NotNull
    @Contract(pure=true)
    public static ToggleButton load(@NotNull Object instance, @NotNull Element element) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        boolean enabled = element.hasAttribute("enabled") && Boolean.parseBoolean(element.getAttribute("enabled"));
        ToggleButton toggleButton = new ToggleButton(length, height, enabled);
        Pane.load(toggleButton, instance, element);
        return toggleButton;
    }
}

