/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane.component;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.font.util.Font;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.Flippable;
import com.github.stefvanschie.inventoryframework.pane.Orientable;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import com.github.stefvanschie.inventoryframework.pane.Rotatable;
import java.util.function.BiFunction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

public class Label
extends OutlinePane {
    @NotNull
    private final Font font;
    @NotNull
    private String text;

    public Label(int x, int y, int length, int height, @NotNull Pane.Priority priority, @NotNull Font font) {
        this(x, y, length, height, font);
        this.setPriority(priority);
    }

    public Label(int x, int y, int length, int height, @NotNull Font font) {
        this(length, height, font);
        this.x = x;
        this.y = y;
    }

    public Label(int length, int height, @NotNull Font font) {
        super(length, height);
        this.font = font;
        this.text = "";
    }

    public void setText(@NotNull String text, @NotNull @NotNull BiFunction<? super @NotNull Character, ? super @NotNull ItemStack, ? extends @NotNull GuiItem> processor) {
        this.text = text;
        this.clear();
        for (char character : text.toCharArray()) {
            ItemStack item = this.font.toItem(character);
            if (item == null) {
                item = this.font.toItem(Character.toUpperCase(character));
            }
            if (item == null) {
                item = this.font.toItem(Character.toLowerCase(character));
            }
            if (item == null) {
                item = this.font.getDefaultItem();
            }
            this.addItem(processor.apply(Character.valueOf(character), (ItemStack)item.clone()));
        }
    }

    public void setText(@NotNull String text) {
        this.setText(text, (character, item) -> new GuiItem((ItemStack)item));
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Label copy() {
        Label label = new Label(this.x, this.y, this.length, this.height, this.getPriority(), this.font);
        for (GuiItem item : this.getItems()) {
            label.addItem(item.copy());
        }
        label.setVisible(this.isVisible());
        label.onClick = this.onClick;
        label.setOrientation(this.getOrientation());
        label.setRotation(this.getRotation());
        label.setGap(this.getGap());
        label.setRepeat(this.doesRepeat());
        label.flipHorizontally(this.isFlippedHorizontally());
        label.flipVertically(this.isFlippedVertically());
        label.applyMask(this.getMask());
        label.uuid = this.uuid;
        label.text = this.text;
        return label;
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        event.setCancelled(true);
        return super.click(gui, inventoryComponent, event, slot, paneOffsetX, paneOffsetY, maxLength, maxHeight);
    }

    @Contract(pure=true)
    @NotNull
    public String getText() {
        return this.text;
    }

    @Contract(pure=true)
    @NotNull
    public Font getFont() {
        return this.font;
    }

    @NotNull
    @Contract(pure=true)
    public static Label load(@NotNull Object instance, @NotNull Element element) {
        int height;
        int length;
        try {
            length = Integer.parseInt(element.getAttribute("length"));
            height = Integer.parseInt(element.getAttribute("height"));
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
        Font font = null;
        if (element.hasAttribute("font")) {
            font = Font.fromName(element.getAttribute("font"));
        }
        if (font == null) {
            throw new XMLLoadException("Incorrect font specified for label");
        }
        Label label = new Label(length, height, font);
        Pane.load(label, instance, element);
        Orientable.load(label, element);
        Flippable.load(label, element);
        Rotatable.load(label, element);
        if (element.hasAttribute("populate")) {
            return label;
        }
        if (element.hasAttribute("text")) {
            label.setText(element.getAttribute("text"));
        }
        return label;
    }
}

