/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.pane;

import com.github.stefvanschie.inventoryframework.exception.XMLLoadException;
import com.github.stefvanschie.inventoryframework.gui.GuiItem;
import com.github.stefvanschie.inventoryframework.gui.InventoryComponent;
import com.github.stefvanschie.inventoryframework.gui.type.util.Gui;
import com.github.stefvanschie.inventoryframework.pane.OutlinePane;
import com.github.stefvanschie.inventoryframework.pane.Pane;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PaginatedPane
extends Pane {
    @NotNull
    private Map<Integer, List<Pane>> panes = new HashMap<Integer, List<Pane>>();
    private int page;

    public PaginatedPane(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        super(x, y, length, height, priority);
    }

    public PaginatedPane(int x, int y, int length, int height) {
        super(x, y, length, height);
    }

    public PaginatedPane(int length, int height) {
        super(length, height);
    }

    public int getPage() {
        return this.page;
    }

    public int getPages() {
        return this.panes.size();
    }

    public void addPane(int page, @NotNull Pane pane) {
        if (!this.panes.containsKey(page)) {
            this.panes.put(page, new ArrayList());
        }
        this.panes.get(page).add(pane);
        this.panes.get(page).sort(Comparator.comparing(Pane::getPriority));
    }

    public void setPage(int page) {
        if (!this.panes.containsKey(page)) {
            throw new ArrayIndexOutOfBoundsException("page outside range");
        }
        this.page = page;
    }

    @Contract(value="null -> fail")
    public void populateWithItemStacks(@NotNull List<ItemStack> items) {
        if (items.isEmpty()) {
            return;
        }
        int itemsPerPage = this.height * this.length;
        int pagesNeeded = (int)Math.max(Math.ceil((double)items.size() / (double)itemsPerPage), 1.0);
        for (int i = 0; i < pagesNeeded; ++i) {
            int index;
            OutlinePane page = new OutlinePane(0, 0, this.length, this.height);
            for (int j = 0; j < itemsPerPage && (index = i * itemsPerPage + j) < items.size(); ++j) {
                page.addItem(new GuiItem(items.get(index)));
            }
            this.addPane(i, page);
        }
    }

    @Contract(value="null -> fail")
    public void populateWithGuiItems(@NotNull List<GuiItem> items) {
        if (items.isEmpty()) {
            return;
        }
        int itemsPerPage = this.height * this.length;
        int pagesNeeded = (int)Math.max(Math.ceil((double)items.size() / (double)itemsPerPage), 1.0);
        for (int i = 0; i < pagesNeeded; ++i) {
            int index;
            OutlinePane page = new OutlinePane(0, 0, this.length, this.height);
            for (int j = 0; j < itemsPerPage && (index = i * itemsPerPage + j) < items.size(); ++j) {
                page.addItem(items.get(index));
            }
            this.addPane(i, page);
        }
    }

    @Contract(value="null, _ -> fail")
    public void populateWithNames(@NotNull List<String> displayNames, @Nullable Material material) {
        if (material == null || material == Material.AIR) {
            return;
        }
        this.populateWithItemStacks(displayNames.stream().map(name -> {
            ItemStack itemStack = new ItemStack(material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
            itemStack.setItemMeta(itemMeta);
            return itemStack;
        }).collect(Collectors.toList()));
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        List<Pane> panes = this.panes.get(this.page);
        if (panes == null) {
            return;
        }
        for (Pane pane : panes) {
            if (!pane.isVisible()) continue;
            int newPaneOffsetX = paneOffsetX + this.getX();
            int newPaneOffsetY = paneOffsetY + this.getY();
            int newMaxLength = Math.min(this.length, maxLength);
            int newMaxHeight = Math.min(this.height, maxHeight);
            pane.display(inventoryComponent, newPaneOffsetX, newPaneOffsetY, newMaxLength, newMaxHeight);
        }
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        int adjustedSlot = slot - (this.getX() + paneOffsetX) - inventoryComponent.getLength() * (this.getY() + paneOffsetY);
        int x = adjustedSlot % inventoryComponent.getLength();
        int y = adjustedSlot / inventoryComponent.getLength();
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        boolean success = false;
        for (Pane pane : new ArrayList(this.panes.getOrDefault(this.page, Collections.emptyList()))) {
            if (!pane.isVisible()) continue;
            success = success || pane.click(gui, inventoryComponent, event, slot, paneOffsetX + this.getX(), paneOffsetY + this.getY(), length, height);
        }
        return success;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public PaginatedPane copy() {
        PaginatedPane paginatedPane = new PaginatedPane(this.x, this.y, this.length, this.height, this.getPriority());
        for (Map.Entry<Integer, List<Pane>> entry : this.panes.entrySet()) {
            for (Pane pane : entry.getValue()) {
                paginatedPane.addPane(entry.getKey(), pane.copy());
            }
        }
        paginatedPane.setVisible(this.isVisible());
        paginatedPane.onClick = this.onClick;
        paginatedPane.uuid = this.uuid;
        paginatedPane.page = this.page;
        return paginatedPane;
    }

    public void deletePage(int page) {
        if (this.panes.remove(page) == null) {
            return;
        }
        HashMap<Integer, List<Pane>> newPanes = new HashMap<Integer, List<Pane>>();
        for (Map.Entry<Integer, List<Pane>> entry : this.panes.entrySet()) {
            int index = entry.getKey();
            List<Pane> panes = entry.getValue();
            if (index > page) {
                newPanes.put(index - 1, panes);
                continue;
            }
            newPanes.put(index, panes);
        }
        this.panes = newPanes;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<Pane> getPanes() {
        HashSet<Pane> panes = new HashSet<Pane>();
        this.panes.forEach((integer, p) -> {
            p.forEach(pane -> panes.addAll(pane.getPanes()));
            panes.addAll((Collection<Pane>)p);
        });
        return panes;
    }

    @NotNull
    @Contract(pure=true)
    public Collection<Pane> getPanes(int page) {
        Collection panes = this.panes.get(page);
        if (panes == null) {
            throw new IllegalArgumentException("Invalid page");
        }
        return Collections.unmodifiableCollection(panes);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<GuiItem> getItems() {
        return this.getPanes().stream().flatMap(pane -> pane.getItems().stream()).collect(Collectors.toList());
    }

    @Override
    public void clear() {
        this.panes.clear();
    }

    @NotNull
    public static PaginatedPane load(@NotNull Object instance, @NotNull Element element) {
        try {
            PaginatedPane paginatedPane = new PaginatedPane(Integer.parseInt(element.getAttribute("length")), Integer.parseInt(element.getAttribute("height")));
            Pane.load(paginatedPane, instance, element);
            if (element.hasAttribute("populate")) {
                return paginatedPane;
            }
            int pageCount = 0;
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                if (!item.getNodeName().equals("page")) {
                    throw new XMLLoadException("Panes have to be inside page tag");
                }
                NodeList innerNodes = item.getChildNodes();
                for (int j = 0; j < innerNodes.getLength(); ++j) {
                    Node pane = innerNodes.item(j);
                    if (pane.getNodeType() != 1) continue;
                    paginatedPane.addPane(pageCount, Gui.loadPane(instance, pane));
                }
                ++pageCount;
            }
            return paginatedPane;
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
    }
}

