/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_18_0;

import com.github.stefvanschie.inventoryframework.abstraction.AnvilInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_18_0.util.CustomInventoryUtil;
import com.github.stefvanschie.inventoryframework.nms.v1_18_0.util.TextHolderUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_18_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    public AnvilInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for an anvil should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        ContainerAnvilImpl containerAnvil = new ContainerAnvilImpl(serverPlayer, items);
        serverPlayer.bW = containerAnvil;
        int id = containerAnvil.j;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        serverPlayer.b.a((Packet)new PacketPlayOutOpenWindow(id, Containers.h, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList<net.minecraft.world.item.ItemStack> nmsItems = CustomInventoryUtil.convertToNMSItems(items);
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.bW.k();
        net.minecraft.world.item.ItemStack cursor = CraftItemStack.asNMSCopy((ItemStack)player.getItemOnCursor());
        ServerPlayerConnection playerConnection = this.getPlayerConnection(serverPlayer);
        playerConnection.a((Packet)new PacketPlayOutWindowItems(containerId, state, nmsItems, cursor));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int state = serverPlayer.bW.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(containerId, state, 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        int state = serverPlayer.bW.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(containerId, state, 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, net.minecraft.world.item.ItemStack.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bW.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(-1, state, -1, net.minecraft.world.item.ItemStack.b));
    }

    private void setCursor(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int state = serverPlayer.bW.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(-1, state, -1, item));
    }

    private void sendResultItem(@NotNull Player player, @NotNull net.minecraft.world.item.ItemStack item) {
        EntityPlayer serverPlayer = this.getServerPlayer(player);
        int containerId = this.getContainerId((EntityHuman)serverPlayer);
        int state = serverPlayer.bW.k();
        this.getPlayerConnection(serverPlayer).a((Packet)new PacketPlayOutSetSlot(containerId, state, 2, item));
    }

    @Contract(pure=true)
    private int getContainerId(@NotNull EntityHuman nmsPlayer) {
        return nmsPlayer.bW.j;
    }

    @NotNull
    @Contract(pure=true)
    private ServerPlayerConnection getPlayerConnection(@NotNull EntityPlayer serverPlayer) {
        return serverPlayer.b;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getServerPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerAnvilImpl
    extends ContainerAnvil {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerAnvilImpl(@Nullable EntityPlayer serverPlayer, ItemStack[] items) {
            super(serverPlayer.nextContainerCounter(), serverPlayer.fq(), ContainerAccess.a((World)serverPlayer.cA(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.player = serverPlayer.getBukkitEntity();
            this.p.a(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.p.a(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.o.a(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                Location location = this.q.getLocation();
                CraftInventoryAnvil inventory = new CraftInventoryAnvil(location, this.p, (IInventory)this.o, this){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return AnvilInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
            }
            return this.bukkitEntity;
        }

        public void a(@Nullable String name) {
            AnvilInventoryImpl.this.text = name == null ? "" : name;
            AnvilInventoryImpl.this.sendResultItem(this.player, this.o.a(0));
        }

        @Contract(pure=true, value="_ -> true")
        public boolean a(@Nullable EntityHuman nmsPlayer) {
            return true;
        }

        public void a(IInventory container) {
        }

        public void b(EntityHuman nmsPlayer) {
        }
    }
}

