/*
 * Decompiled with CFR 0.152.
 */
package com.github.stefvanschie.inventoryframework.nms.v1_16_2_3;

import com.github.stefvanschie.inventoryframework.abstraction.AnvilInventory;
import com.github.stefvanschie.inventoryframework.adventuresupport.TextHolder;
import com.github.stefvanschie.inventoryframework.nms.v1_16_2_3.util.TextHolderUtil;
import net.minecraft.server.v1_16_R2.BlockPosition;
import net.minecraft.server.v1_16_R2.Container;
import net.minecraft.server.v1_16_R2.ContainerAccess;
import net.minecraft.server.v1_16_R2.ContainerAnvil;
import net.minecraft.server.v1_16_R2.Containers;
import net.minecraft.server.v1_16_R2.EntityHuman;
import net.minecraft.server.v1_16_R2.EntityPlayer;
import net.minecraft.server.v1_16_R2.IChatBaseComponent;
import net.minecraft.server.v1_16_R2.IInventory;
import net.minecraft.server.v1_16_R2.NonNullList;
import net.minecraft.server.v1_16_R2.Packet;
import net.minecraft.server.v1_16_R2.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_16_R2.PacketPlayOutSetSlot;
import net.minecraft.server.v1_16_R2.PacketPlayOutWindowItems;
import net.minecraft.server.v1_16_R2.PlayerConnection;
import net.minecraft.server.v1_16_R2.World;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R2.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilInventoryImpl
extends AnvilInventory {
    public AnvilInventoryImpl(@NotNull InventoryHolder inventoryHolder) {
        super(inventoryHolder);
    }

    @Override
    public void openInventory(@NotNull Player player, @NotNull TextHolder title, @Nullable ItemStack[] items) {
        int itemAmount = items.length;
        if (itemAmount != 3) {
            throw new IllegalArgumentException("The amount of items for an anvil should be 3, but is '" + itemAmount + "'");
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        ContainerAnvilImpl containerAnvil = new ContainerAnvilImpl(entityPlayer, items);
        entityPlayer.activeContainer = containerAnvil;
        int id = containerAnvil.windowId;
        IChatBaseComponent message = TextHolderUtil.toComponent(title);
        entityPlayer.playerConnection.sendPacket((Packet)new PacketPlayOutOpenWindow(id, Containers.ANVIL, message));
        this.sendItems(player, items);
    }

    @Override
    public void sendItems(@NotNull Player player, @Nullable ItemStack[] items) {
        NonNullList nmsItems = NonNullList.a((Object)net.minecraft.server.v1_16_R2.ItemStack.b, (Object[])new net.minecraft.server.v1_16_R2.ItemStack[]{CraftItemStack.asNMSCopy((ItemStack)items[0]), CraftItemStack.asNMSCopy((ItemStack)items[1]), CraftItemStack.asNMSCopy((ItemStack)items[2])});
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutWindowItems(this.getWindowId(entityPlayer), nmsItems));
    }

    @Override
    public void sendFirstItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        net.minecraft.server.v1_16_R2.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(this.getWindowId(entityPlayer), 0, nmsItem));
    }

    @Override
    public void sendSecondItem(@NotNull Player player, @Nullable ItemStack item) {
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        net.minecraft.server.v1_16_R2.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(this.getWindowId(entityPlayer), 1, nmsItem));
    }

    @Override
    public void sendResultItem(@NotNull Player player, @Nullable ItemStack item) {
        this.sendResultItem(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearResultItem(@NotNull Player player) {
        this.sendResultItem(player, net.minecraft.server.v1_16_R2.ItemStack.b);
    }

    @Override
    public void setCursor(@NotNull Player player, @NotNull ItemStack item) {
        this.setCursor(player, CraftItemStack.asNMSCopy((ItemStack)item));
    }

    @Override
    public void clearCursor(@NotNull Player player) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, net.minecraft.server.v1_16_R2.ItemStack.b));
    }

    private void setCursor(@NotNull Player player, @NotNull net.minecraft.server.v1_16_R2.ItemStack item) {
        this.getPlayerConnection(this.getEntityPlayer(player)).sendPacket((Packet)new PacketPlayOutSetSlot(-1, -1, item));
    }

    private void sendResultItem(@NotNull Player player, @NotNull net.minecraft.server.v1_16_R2.ItemStack item) {
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        this.getPlayerConnection(entityPlayer).sendPacket((Packet)new PacketPlayOutSetSlot(this.getWindowId(entityPlayer), 2, item));
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    @NotNull
    @Contract(pure=true)
    private PlayerConnection getPlayerConnection(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.playerConnection;
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    private class ContainerAnvilImpl
    extends ContainerAnvil {
        @NotNull
        private final Player player;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerAnvilImpl(@Nullable EntityPlayer entityPlayer, ItemStack[] items) {
            super(entityPlayer.nextContainerCounter(), entityPlayer.inventory, ContainerAccess.at((World)entityPlayer.getWorld(), (BlockPosition)new BlockPosition(0, 0, 0)));
            this.player = entityPlayer.getBukkitEntity();
            this.repairInventory.setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[0]));
            this.repairInventory.setItem(1, CraftItemStack.asNMSCopy((ItemStack)items[1]));
            this.resultInventory.setItem(0, CraftItemStack.asNMSCopy((ItemStack)items[2]));
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity == null) {
                Location location = this.containerAccess.getLocation();
                CraftInventoryAnvil inventory = new CraftInventoryAnvil(location, this.repairInventory, (IInventory)this.resultInventory, this){

                    @NotNull
                    @Contract(pure=true)
                    public InventoryHolder getHolder() {
                        return AnvilInventoryImpl.this.inventoryHolder;
                    }
                };
                this.bukkitEntity = new CraftInventoryView((HumanEntity)this.player, (Inventory)inventory, (Container)this);
            }
            return this.bukkitEntity;
        }

        public void a(@Nullable String name) {
            AnvilInventoryImpl.this.text = name == null ? "" : name;
            AnvilInventoryImpl.this.sendResultItem(this.player, this.resultInventory.getItem(0));
        }

        @Contract(pure=true, value="_ -> true")
        public boolean canUse(@Nullable EntityHuman entityhuman) {
            return true;
        }

        public void a(IInventory inventory) {
        }

        public void b(EntityHuman entityhuman) {
        }
    }
}

