/*
 * Decompiled with CFR 0.152.
 */
package com.justinmtech.autoreboot.autoreboot;

import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class AutoReboot
extends JavaPlugin
implements Listener {
    private boolean hasAnnounced;

    public void onEnable() {
        this.setHasAnnounced(false);
        this.saveDefaultConfig();
        this.rebootChecker();
        this.getLogger().log(Level.INFO, "Plugin enabled.");
    }

    public void onDisable() {
        this.getLogger().log(Level.INFO, "Plugin disabled.");
    }

    private int getUptimeInSeconds() {
        return (int)ManagementFactory.getRuntimeMXBean().getUptime() / 1000;
    }

    private int getUptimeInHours() {
        int seconds = this.getUptimeInSeconds();
        int minutes = seconds / 60;
        return minutes / 60;
    }

    private int getRebootInterval() {
        return this.getConfig().getInt("interval", 24);
    }

    private int getRebootIntervalInSeconds() {
        int hours = this.getRebootInterval();
        int minutes = hours * 60;
        return minutes * 60;
    }

    private boolean isOneMinuteBefore() {
        return this.getRebootIntervalInSeconds() - this.getUptimeInSeconds() <= 60;
    }

    private boolean isRebootTime() {
        return this.getUptimeInHours() >= this.getRebootInterval();
    }

    private void rebootChecker() {
        final String msg = ChatColor.translateAlternateColorCodes((char)'&', (String)this.getConfig().getString("warning", "\u00a7cThe server is rebooting in 1 minute!"));
        final int playerThreshold = this.getConfig().getInt("player-threshold", 0);
        new BukkitRunnable(){

            public void run() {
                if (AutoReboot.this.getOnlinePlayerCount() <= playerThreshold) {
                    if (AutoReboot.this.isOneMinuteBefore() && !AutoReboot.this.isHasAnnounced()) {
                        Bukkit.broadcastMessage((String)msg);
                        AutoReboot.this.setHasAnnounced(true);
                    }
                    if (AutoReboot.this.isRebootTime()) {
                        this.cancel();
                        Bukkit.shutdown();
                    }
                }
            }
        }.runTaskTimer((Plugin)this, 600L, 600L);
    }

    private int getOnlinePlayerCount() {
        return Bukkit.getOnlinePlayers().size();
    }

    private boolean isHasAnnounced() {
        return this.hasAnnounced;
    }

    private void setHasAnnounced(boolean hasAnnounced) {
        this.hasAnnounced = hasAnnounced;
    }
}

