/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.model.BlueprintBone;
import com.ticxo.modelengine.api.generator.model.ModelBlueprint;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.nms.entity.fake.VFXRenderer;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.utils.math.TMath;
import org.bukkit.Color;
import org.bukkit.entity.Player;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class VFXImpl
implements VFX {
    private final BaseEntity<?> base;
    private final RangeManager rangeManager;
    private final VFXRenderer renderer;
    private boolean isSmall;
    private int data;
    private Color color;
    private boolean isEnchant;
    private boolean isVisible = true;
    private Vector position;
    private EulerAngle targetRotation = EulerAngle.ZERO;
    private EulerAngle rotation = EulerAngle.ZERO;
    private float yaw;
    private boolean isAutoTick;
    private boolean isBaseEntityVisible = true;
    private boolean isInitialized = false;
    private boolean isAlive = true;

    public VFXImpl(BaseEntity<?> base) {
        this.base = base;
        this.rangeManager = base.wrapRangeManager(this);
        this.renderer = ModelEngineAPI.getEntityHandler().createVFXRenderer(this);
    }

    @Override
    public boolean tick() {
        if (!this.isInitialized) {
            return this.isAlive;
        }
        if (this.isAutoTick) {
            this.locationUpdate();
            this.update();
        }
        return !this.base.isDead() && this.isAlive;
    }

    @Override
    public void create() {
        this.locationUpdate();
        this.renderer.initialize();
        this.renderer.spawn();
        ModelEngineAPI.getVFXTicker().registerVFX(this.base, this);
        this.isInitialized = true;
    }

    @Override
    public void update() {
        this.renderer.update();
    }

    @Override
    public void destroy() {
        this.renderer.despawn();
        this.isAlive = false;
    }

    @Override
    public void useModel(String modelId, String boneId) {
        ModelBlueprint blueprint = ModelEngineAPI.getBlueprint(modelId);
        if (blueprint == null) {
            return;
        }
        BlueprintBone bone = blueprint.getFlatMap().get(boneId);
        if (bone == null) {
            return;
        }
        Integer id = blueprint.getItemIds().get(boneId);
        if (id == null) {
            return;
        }
        this.setData(id);
        this.setSmall(!bone.check("large"));
    }

    @Override
    public void setSmall(boolean flag) {
        this.isSmall = flag;
        if (this.isInitialized) {
            this.renderer.setSmall(flag);
        }
    }

    @Override
    public void setData(int data) {
        this.data = data;
        if (this.isInitialized) {
            this.renderer.setData(data);
        }
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        if (this.isInitialized) {
            this.renderer.setColor(color);
        }
    }

    @Override
    public void setEnchant(boolean flag) {
        this.isEnchant = flag;
        if (this.isInitialized) {
            this.renderer.setEnchant(flag);
        }
    }

    @Override
    public void setVisible(boolean flag) {
        this.isVisible = flag;
        if (this.isInitialized) {
            this.renderer.setModelVisible(flag);
        }
    }

    @Override
    public void rotate(EulerAngle angle, boolean newOrigin) {
        this.setRotation(newOrigin ? TMath.localRotate(this.rotation, angle) : TMath.globalRotate(this.rotation, angle));
    }

    @Override
    public void point(Vector vector, boolean overwrite) {
        double dX = vector.getX() - this.position.getX();
        double dY = vector.getY() - this.position.getY();
        double dZ = vector.getZ() - this.position.getZ();
        double hMagnitude = TMath.fastSqrt(dX * dX + dZ * dZ);
        float pitch = (float)(-TMath.fastAtan2(dY, hMagnitude));
        float yaw = (float)Math.toDegrees(TMath.fastAtan2(-dX, dZ));
        this.targetRotation = new EulerAngle((double)pitch, 0.0, 0.0);
        this.setYaw(yaw);
        if (overwrite) {
            this.setRotation(EulerAngle.ZERO);
        }
    }

    @Override
    public EulerAngle getRotation() {
        return TMath.localRotate(this.targetRotation, this.rotation);
    }

    @Override
    public void setBaseEntityVisible(boolean flag) {
        if (this.isBaseEntityVisible == flag) {
            return;
        }
        this.isBaseEntityVisible = flag;
        if (flag) {
            this.base.broadcastSpawnPacket();
        } else {
            this.base.broadcastDespawnPacket();
        }
    }

    @Override
    public void showToPlayer(Player player) {
        this.renderer.spawn(player);
    }

    @Override
    public void hideFromPlayer(Player player) {
        this.renderer.despawn(player);
    }

    protected void locationUpdate() {
        this.position = this.base.getLocation().toVector();
        this.targetRotation = TMath.makeAngle(this.base.getXHeadRot(), 0.0, 0.0);
        this.yaw = this.base.getYHeadRot();
    }

    @Override
    public BaseEntity<?> getBase() {
        return this.base;
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    @Override
    public VFXRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public boolean isSmall() {
        return this.isSmall;
    }

    @Override
    public int getData() {
        return this.data;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isEnchant() {
        return this.isEnchant;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public Vector getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector position) {
        this.position = position;
    }

    @Override
    public void setRotation(EulerAngle rotation) {
        this.rotation = rotation;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    @Override
    public boolean isAutoTick() {
        return this.isAutoTick;
    }

    @Override
    public void setAutoTick(boolean isAutoTick) {
        this.isAutoTick = isAutoTick;
    }

    @Override
    public boolean isBaseEntityVisible() {
        return this.isBaseEntityVisible;
    }
}

