/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_1_R1.world.phys;

import com.ticxo.modelengine.api.utils.math.Offset;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.api.utils.math.Quaternion;
import java.util.Optional;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftVector;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class OBB
extends AxisAlignedBB {
    private final EulerAngle rotation;
    private final float yaw;
    private final OrientedBoundingBox bukkitOBB;

    public OBB(double x, double y, double z, EulerAngle rotation, float yaw) {
        this(-x / 2.0, -y / 2.0, -z / 2.0, x / 2.0, y / 2.0, z / 2.0, rotation, yaw);
    }

    public OBB(Vec3D cornerA, Vec3D cornerB, EulerAngle rotation, float yaw) {
        this(cornerA.c, cornerA.d, cornerA.e, cornerB.c, cornerB.d, cornerB.e, rotation, yaw);
    }

    public OBB(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, EulerAngle rotation, float yaw) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.rotation = rotation;
        this.yaw = yaw;
        this.bukkitOBB = new OrientedBoundingBox(CraftVector.toBukkit((Vec3D)this.f()), new Vector(this.b(), this.c(), this.d()), rotation, yaw);
    }

    public OBB makeOBBInstance(Vec3D position, EulerAngle rotations, float yaw) {
        return new OBB(position.b(this.a, this.b, this.c), position.b(this.d, this.e, this.f), rotations, yaw);
    }

    public AxisAlignedBB c(double xInflate, double yInflate, double zInflate) {
        double minX = this.a - xInflate;
        double minY = this.b - yInflate;
        double minZ = this.c - zInflate;
        double maxX = this.d + xInflate;
        double maxY = this.e + yInflate;
        double maxZ = this.f + zInflate;
        return new OBB(minX, minY, minZ, maxX, maxY, maxZ, this.rotation, this.yaw);
    }

    public boolean c(AxisAlignedBB aabb) {
        boolean bl;
        if (aabb instanceof OBB) {
            OBB obb = (OBB)aabb;
            bl = this.intersects(obb);
        } else {
            bl = super.c(aabb);
        }
        return bl;
    }

    public boolean intersects(OBB obb) {
        return this.bukkitOBB.intersects(obb.bukkitOBB);
    }

    public boolean a(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        OrientedBoundingBox obbB = new OrientedBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        return this.bukkitOBB.intersects(obbB);
    }

    public Optional<Vec3D> b(Vec3D from, Vec3D to) {
        EulerAngle inverseRotation = Quaternion.fromEulerAngle(this.rotation).conjugate().toEulerAngle();
        Vector bukkitCenter = CraftVector.toBukkit((Vec3D)this.f());
        Vector bukkitFrom = CraftVector.toBukkit((Vec3D)from);
        Vector bukkitTo = CraftVector.toBukkit((Vec3D)to);
        Offset.getRelativeLocation(inverseRotation, bukkitFrom.subtract(bukkitCenter)).add(bukkitCenter);
        Offset.getRelativeLocation(inverseRotation, bukkitTo.subtract(bukkitCenter)).add(bukkitCenter);
        Optional result = super.b(CraftVector.toNMS((Vector)bukkitFrom), CraftVector.toNMS((Vector)bukkitTo));
        if (result.isEmpty()) {
            return result;
        }
        Vector bukkitResult = CraftVector.toBukkit((Vec3D)((Vec3D)result.get()));
        Offset.getRelativeLocation(this.rotation, bukkitResult.subtract(bukkitCenter)).add(bukkitCenter);
        return Optional.of(CraftVector.toNMS((Vector)bukkitResult));
    }

    public String toString() {
        return "OBB(rotation=" + this.rotation + ", yaw=" + this.yaw + ", bukkitOBB=" + this.getBukkitOBB() + ")";
    }

    public OrientedBoundingBox getBukkitOBB() {
        return this.bukkitOBB;
    }
}

