/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_1_R1.world;

import com.google.common.collect.Lists;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.world.WorldHandler;
import com.ticxo.modelengine.api.utils.math.OrientedBoundingBox;
import com.ticxo.modelengine.api.utils.math.TMath;
import io.papermc.paper.chunk.system.entity.EntityLookup;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.boss.EntityComplexPart;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R1.CraftFluidCollisionMode;
import org.bukkit.craftbukkit.v1_19_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftRayTraceResult;
import org.bukkit.entity.Entity;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class WorldHandlerImpl
implements WorldHandler {
    private static Method entityGetter;

    @Override
    public RayTraceResult asyncRayTrace(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks, double raySize, Predicate<Entity> filter) {
        RayTraceResult blockHit = this.asyncRayTraceBlocks(start, direction, maxDistance, fluidCollisionMode, ignorePassableBlocks);
        Vector startVec = null;
        double blockHitDistance = maxDistance;
        if (blockHit != null) {
            startVec = start.toVector();
            blockHitDistance = TMath.fastSqrt(startVec.distanceSquared(blockHit.getHitPosition()));
        }
        RayTraceResult entityHit = this.asyncRayTraceEntities(start, direction, blockHitDistance, raySize, filter);
        if (blockHit == null) {
            return entityHit;
        }
        if (entityHit == null) {
            return blockHit;
        }
        double entityHitDistanceSquared = startVec.distanceSquared(entityHit.getHitPosition());
        return entityHitDistanceSquared < blockHitDistance * blockHitDistance ? entityHit : blockHit;
    }

    private RayTraceResult asyncRayTraceBlocks(Location start, Vector direction, double maxDistance, FluidCollisionMode fluidCollisionMode, boolean ignorePassableBlocks) {
        if (maxDistance < 0.0 || start.getWorld() == null) {
            return null;
        }
        WorldServer level = ((CraftWorld)start.getWorld()).getHandle();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        Vec3D startPos = new Vec3D(start.getX(), start.getY(), start.getZ());
        Vec3D endPos = new Vec3D(start.getX() + dir.getX(), start.getY() + dir.getY(), start.getZ() + dir.getZ());
        MovingObjectPositionBlock nmsHitResult = level.a(new RayTrace(startPos, endPos, ignorePassableBlocks ? RayTrace.BlockCollisionOption.a : RayTrace.BlockCollisionOption.b, CraftFluidCollisionMode.toNMS((FluidCollisionMode)fluidCollisionMode), null));
        return CraftRayTraceResult.fromNMS((World)start.getWorld(), (MovingObjectPosition)nmsHitResult);
    }

    private RayTraceResult asyncRayTraceEntities(Location start, Vector direction, double maxDistance, double raySize, Predicate<Entity> filter) {
        if (maxDistance < 0.0 || start.getWorld() == null) {
            return null;
        }
        WorldServer level = ((CraftWorld)start.getWorld()).getHandle();
        Vector startPos = start.toVector();
        Vector dir = direction.clone().normalize().multiply(maxDistance);
        BoundingBox aabb = BoundingBox.of((Vector)startPos, (Vector)startPos).expandDirectional(dir).expand(raySize);
        Collection<Entity> entities = this.asyncGetNearbyEntities(level, aabb, filter);
        Entity nearestHitEntity = null;
        RayTraceResult nearestHitResult = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (Entity entity : entities) {
            double distanceSq;
            RayTraceResult hitResult;
            SubHitbox bone = ModelEngineAPI.getModelTicker().getSubHitboxBone(entity.getUniqueId());
            if (bone != null && bone.isOBB()) {
                OrientedBoundingBox orientedBoundingBox = bone.getSubHitboxEntity().getObbInstance();
                if (orientedBoundingBox == null) continue;
                hitResult = orientedBoundingBox.rayTrace(startPos, direction, maxDistance, (Consumer<BoundingBox>)((Consumer)boundingBox -> boundingBox.expand(raySize)));
            } else {
                BoundingBox boundingBox2 = entity.getBoundingBox().expand(raySize);
                hitResult = boundingBox2.rayTrace(startPos, direction, maxDistance);
            }
            if (hitResult == null || !((distanceSq = startPos.distanceSquared(hitResult.getHitPosition())) < nearestDistanceSq)) continue;
            nearestHitEntity = entity;
            nearestHitResult = hitResult;
            nearestDistanceSq = distanceSq;
        }
        return nearestHitEntity == null ? null : new RayTraceResult(nearestHitResult.getHitPosition(), nearestHitEntity, nearestHitResult.getHitBlockFace());
    }

    private Collection<Entity> asyncGetNearbyEntities(WorldServer level, BoundingBox boundingBox, Predicate<Entity> filter) {
        AxisAlignedBB bb = new AxisAlignedBB(boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMinZ(), boundingBox.getMaxX(), boundingBox.getMaxY(), boundingBox.getMaxZ());
        List<net.minecraft.world.entity.Entity> entityList = this.asyncGetEntities(level, bb, entity -> true);
        ArrayList<Entity> bukkitEntityList = new ArrayList<Entity>(entityList.size());
        Iterator<net.minecraft.world.entity.Entity> var7 = entityList.iterator();
        while (var7.hasNext()) {
            net.minecraft.world.entity.Entity entity2 = var7.next();
            CraftEntity bukkitEntity = entity2.getBukkitEntity();
            if (filter != null && !filter.test((Entity)bukkitEntity)) continue;
            bukkitEntityList.add((Entity)bukkitEntity);
        }
        return bukkitEntityList;
    }

    private List<net.minecraft.world.entity.Entity> asyncGetEntities(WorldServer level, AxisAlignedBB axisalignedbb, Predicate<? super net.minecraft.world.entity.Entity> predicate) {
        ArrayList list = Lists.newArrayList();
        try {
            WorldHandlerImpl.getEntityGetter(level).a(axisalignedbb, entity1 -> {
                if (entity1 != null && predicate.test((net.minecraft.world.entity.Entity)entity1)) {
                    list.add(entity1);
                }
                if (entity1 instanceof EntityEnderDragon) {
                    EntityComplexPart[] aentitycomplexpart;
                    for (EntityComplexPart entitycomplexpart : aentitycomplexpart = ((EntityEnderDragon)entity1).t()) {
                        if (!predicate.test((net.minecraft.world.entity.Entity)entitycomplexpart)) continue;
                        list.add(entitycomplexpart);
                    }
                }
            });
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return list;
    }

    public static LevelEntityGetter<net.minecraft.world.entity.Entity> getEntityGetter(WorldServer level) {
        if (entityGetter == null) {
            return level.P.d();
        }
        try {
            return (LevelEntityGetter)entityGetter.invoke((Object)level, new Object[0]);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void addNewEntity(WorldServer level, net.minecraft.world.entity.Entity entity) {
        if (entityGetter == null) {
            level.P.a((EntityAccess)entity);
            return;
        }
        ((EntityLookup)WorldHandlerImpl.getEntityGetter(level)).addNewEntity(entity);
    }

    static {
        for (Method method : WorldServer.class.getMethods()) {
            if (!LevelEntityGetter.class.isAssignableFrom(method.getReturnType()) || method.getReturnType() == LevelEntityGetter.class) continue;
            entityGetter = method;
            break;
        }
    }
}

