/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_1_R1.network;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.config.ConfigProperty;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelPipeline;
import java.util.List;
import java.util.Set;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class NetworkUtils {
    private static boolean compressPacket = true;

    protected static void updateConfigs() {
        compressPacket = ConfigProperty.COMPRESS_PACKET.getBoolean();
    }

    public static PacketDataSerializer createByteBuf() {
        return new PacketDataSerializer(Unpooled.buffer());
    }

    public static Integer getPacketId(Packet<?> packet) {
        return EnumProtocol.b.a(EnumProtocolDirection.b, packet);
    }

    @Nullable
    public static PacketDataSerializer createCompressedPacket(Packet<?> packet) {
        Integer packetId = NetworkUtils.getPacketId(packet);
        if (packetId == null) {
            return null;
        }
        PacketDataSerializer bb = NetworkUtils.createByteBuf();
        bb.writeByte(packetId.intValue());
        packet.a(bb);
        return bb;
    }

    public static PacketDataSerializer readData(Packet<?> packet) {
        PacketDataSerializer buf = NetworkUtils.createByteBuf();
        packet.a(buf);
        return buf;
    }

    public static void send(Set<Player> players, Packet<?> ... packets) {
        for (Player player : players) {
            NetworkUtils.send(player, packets);
        }
    }

    public static void send(Player player, Packet<?> ... packets) {
        ChannelPipeline pipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (pipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : packets) {
                PacketDataSerializer byteBuf;
                if (packet == null || (byteBuf = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                pipeline.write((Object)byteBuf);
            }
        } else {
            for (Packet<?> packet : packets) {
                if (packet == null) continue;
                pipeline.write(packet);
            }
        }
        pipeline.flush();
    }

    public static void send(Set<Player> players, List<Packet<?>> packets) {
        for (Player player : players) {
            NetworkUtils.send(player, packets);
        }
    }

    public static void send(Player player, List<Packet<?>> packets) {
        ChannelPipeline pipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (pipeline == null) {
            return;
        }
        if (compressPacket) {
            for (Packet<?> packet : packets) {
                PacketDataSerializer byteBuf;
                if (packet == null || (byteBuf = NetworkUtils.createCompressedPacket(packet)) == null) continue;
                pipeline.write((Object)byteBuf);
            }
        } else {
            for (Packet<?> packet : packets) {
                if (packet == null) continue;
                pipeline.write(packet);
            }
        }
        pipeline.flush();
    }

    public static void send(Player player, PacketDataSerializer ... packets) {
        ChannelPipeline pipeline = ModelEngineAPI.getNetworkHandler().getPipeline(player);
        if (pipeline == null) {
            return;
        }
        for (PacketDataSerializer packet : packets) {
            if (packet == null) continue;
            pipeline.write((Object)packet);
        }
        pipeline.flush();
    }
}

