/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_1_R1.entity.fake.hitbox;

import com.ticxo.modelengine.api.nms.entity.hitbox.DynamicHitbox;
import com.ticxo.modelengine.nms.v1_19_1_R1.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_19_1_R1.network.NetworkUtils;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

public class DynamicHitboxImpl
implements DynamicHitbox {
    private static final double OFFSET = -0.6351;
    private final int slimeId;
    private final UUID slimeUUID;
    private final int cloudId;
    private final UUID cloudUUID;
    private final PacketPlayOutEntityMetadata slimeMeta;
    private final PacketPlayOutEntityMetadata cloudMeta;

    public DynamicHitboxImpl(AtomicInteger entityCounter) {
        this.slimeId = entityCounter.incrementAndGet();
        this.slimeUUID = UUID.randomUUID();
        this.cloudId = entityCounter.incrementAndGet();
        this.cloudUUID = UUID.randomUUID();
        DataWatcher.Item commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)32);
        DataWatcher.Item airTickDataItem = new DataWatcher.Item(DataAccessors.AIR_TICK, (Object)Integer.MAX_VALUE);
        DataWatcher.Item sizeDataItem = new DataWatcher.Item(DataAccessors.SIZE_DATA, (Object)2);
        DataWatcher.Item cloudRadius = new DataWatcher.Item(DataAccessors.CLOUD_RADIUS, (Object)Float.valueOf(0.0f));
        this.slimeMeta = this.meta(this.slimeId, List.of(commonDataItem, airTickDataItem, sizeDataItem));
        this.cloudMeta = this.meta(this.cloudId, List.of(commonDataItem, cloudRadius));
    }

    @Override
    public void spawn(Player player) {
        Location location = player.getLocation();
        PacketPlayOutSpawnEntity spawnSlime = this.spawnSlime(location.getX(), location.getY() - 60.0, location.getZ());
        PacketPlayOutSpawnEntity spawnCloud = this.spawnCloud(location.getX(), location.getY() - 60.0, location.getZ());
        PacketPlayOutMount mount = this.addPassengers();
        NetworkUtils.send(player, new Packet[]{spawnSlime, spawnCloud, this.slimeMeta, this.cloudMeta, mount});
    }

    @Override
    public void updateActive(Player player, RayTraceResult result) {
        Vector pos = result.getHitPosition();
        PacketPlayOutEntityTeleport move = this.move(pos.getX(), pos.getY() + -0.6351, pos.getZ());
        NetworkUtils.send(player, new Packet[]{move});
    }

    @Override
    public void updateInactive(Player player) {
        Location pos = player.getLocation();
        PacketPlayOutEntityTeleport move = this.move(pos.getX(), pos.getY() - 60.0, pos.getZ());
        NetworkUtils.send(player, new Packet[]{move});
    }

    private PacketPlayOutSpawnEntity spawnSlime(double x, double y, double z) {
        PacketDataSerializer spawn = NetworkUtils.createByteBuf();
        spawn.d(this.slimeId);
        spawn.a(this.slimeUUID);
        spawn.d(IRegistry.X.a((Object)EntityTypes.aG));
        spawn.writeDouble(x);
        spawn.writeDouble(y);
        spawn.writeDouble(z);
        spawn.writeByte(0);
        spawn.writeByte(0);
        spawn.writeInt(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        return new PacketPlayOutSpawnEntity(spawn);
    }

    private PacketPlayOutSpawnEntity spawnCloud(double x, double y, double z) {
        PacketDataSerializer spawn = NetworkUtils.createByteBuf();
        spawn.d(this.cloudId);
        spawn.a(this.cloudUUID);
        spawn.d(IRegistry.X.a((Object)EntityTypes.c));
        spawn.writeDouble(x);
        spawn.writeDouble(y);
        spawn.writeDouble(z);
        spawn.writeByte(0);
        spawn.writeByte(0);
        spawn.writeInt(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        return new PacketPlayOutSpawnEntity(spawn);
    }

    private PacketPlayOutEntityMetadata meta(int id, List<DataWatcher.Item<?>> list) {
        PacketDataSerializer data = NetworkUtils.createByteBuf();
        data.d(id);
        DataWatcher.a(list, (PacketDataSerializer)data);
        return new PacketPlayOutEntityMetadata(data);
    }

    private PacketPlayOutEntityTeleport move(double x, double y, double z) {
        PacketDataSerializer pos = NetworkUtils.createByteBuf();
        pos.d(this.cloudId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte(0);
        pos.writeByte(0);
        pos.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(pos);
    }

    public PacketPlayOutMount addPassengers() {
        PacketDataSerializer mount = NetworkUtils.createByteBuf();
        mount.d(this.cloudId);
        mount.d(1);
        mount.d(this.slimeId);
        return new PacketPlayOutMount(mount);
    }
}

