/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_1_R1.entity.fake.bone;

import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.LeashPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_19_1_R1.entity.fake.FakeSlime;
import com.ticxo.modelengine.nms.v1_19_1_R1.network.NetworkUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;

public class LeashPointImplAC
implements LeashPoint {
    private ModelBone bone;
    private RangeManager rangeManager;
    private FakeSlime slime;
    private int holder;
    private boolean isInitialized = false;
    private final boolean isC;

    public LeashPointImplAC(ModelBone bone, boolean isC) {
        this.setBone(bone);
        this.isC = isC;
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.slime = new FakeSlime(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity slimeSpawn = this.slime.spawn();
        PacketPlayOutEntityMetadata slimeMeta = this.slime.meta();
        PacketPlayOutAttachEntity link = this.slime.leash(this.holder);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{slimeSpawn, slimeMeta, link});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity slimeSpawn = this.slime.spawn();
        PacketPlayOutEntityMetadata slimeMeta = this.slime.meta();
        PacketPlayOutAttachEntity link = this.slime.leash(this.holder);
        NetworkUtils.send(player, new Packet[]{slimeSpawn, slimeMeta, link});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.slime.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.slime.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        PacketPlayOutEntityTeleport slimePosition = this.isC ? this.slime.updatePositionCalibrated(this.bone.getPosition()) : this.slime.updatePosition(this.bone.getPosition());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{slimePosition});
    }

    @Override
    public int getLeashId() {
        return this.slime.getEntityId();
    }

    @Override
    public void setHolder(int id) {
        if (this.holder == id) {
            return;
        }
        this.holder = id;
        PacketPlayOutAttachEntity link = this.slime.leash(id);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{link});
    }

    public FakeSlime getSlime() {
        return this.slime;
    }

    @Override
    public int getHolder() {
        return this.holder;
    }
}

