/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_1_R1.entity.fake.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.bone.Renderer;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_19_1_R1.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_19_1_R1.network.NetworkUtils;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.EulerAngle;

public class BoneRendererImplAC
implements BoneRenderer {
    private static final ItemStack empty = new ItemStack(Material.AIR);
    private ModelBone bone;
    private Renderer rendererBone;
    private RangeManager rangeManager;
    private FakeArmorStand armorStand;
    private ItemStack item;
    private boolean isItemDirty;
    private int data = -1;
    private Color color = Color.WHITE;
    private boolean isEnchant;
    private boolean isModelVisible = true;
    private boolean isInitialized = false;
    private final boolean isC;

    public BoneRendererImplAC(ModelBone bone, boolean isC) {
        this.setBone(bone);
        this.isC = isC;
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.rendererBone = bone instanceof Renderer ? (Renderer)bone : null;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        boolean isSmall = !this.bone.getBlueprintBone().check("large");
        this.armorStand = new FakeArmorStand(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setRotation(this.getBoneRotation());
        this.armorStand.setInvisible(true);
        this.armorStand.setSmall(isSmall);
        this.armorStand.setDisplay(FakeEntity.DisplaySlot.HEAD);
        if (this.rendererBone.isGhost()) {
            this.item = empty;
            return;
        }
        this.item = ModelEngineAPI.api.getGenerator().getBaseItemType().create();
        int tempId = this.data;
        if (this.data == -1) {
            tempId = this.bone.getActiveModel().getBlueprint().getItemIds().get(this.bone.getBoneId());
        }
        this.setData(tempId);
        Color tempColor = this.color;
        this.color = null;
        this.setColor(tempColor);
        this.isItemDirty = false;
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorSpawn, armorMeta});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorEquip}));
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        NetworkUtils.send(player, new Packet[]{armorSpawn, armorMeta});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(player, new Packet[]{armorEquip}));
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setRotation(this.getBoneRotation());
        Packet<PacketListenerPlayOut> armorPosition = this.isC ? this.armorStand.updatePositionCalibrated(this.bone.getYaw(), this.bone.getPosition()) : this.armorStand.updatePosition(this.bone.getYaw(), this.bone.getPosition());
        PacketPlayOutEntityMetadata armorPose = this.armorStand.updateMeta(false);
        PacketPlayOutEntityEquipment armorEquip = null;
        if (this.isItemDirty) {
            armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
            this.isItemDirty = false;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorPosition, armorPose, armorEquip});
    }

    @Override
    public void updateModel() {
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorEquip});
    }

    @Override
    public void setSmall(boolean flag) {
        this.armorStand.setSmall(flag);
    }

    @Override
    public void setModel(ItemStack item) {
        this.item = item;
        this.isItemDirty = true;
    }

    @Override
    public void setModelVisible(boolean flag) {
        this.isModelVisible = flag;
        this.isItemDirty = true;
    }

    @Override
    public void setGlowing(boolean flag) {
        this.armorStand.setGlowing(flag);
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(false);
        if (armorMeta == null) {
            return;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorMeta});
    }

    @Override
    public void setColor(Color color) {
        if (color.equals((Object)this.color)) {
            return;
        }
        this.color = color;
        if (this.isGhost()) {
            return;
        }
        BaseItemEnum baseItemEnum = ModelEngineAPI.api.getGenerator().getBaseItemType();
        ItemMeta meta = this.item.getItemMeta();
        baseItemEnum.color(meta, color);
        this.item.setItemMeta(meta);
        this.isItemDirty = true;
    }

    @Override
    public void setEnchant(boolean flag) {
        if (this.isEnchant == flag) {
            return;
        }
        this.isEnchant = flag;
        if (this.isGhost()) {
            return;
        }
        if (flag) {
            this.item.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        } else {
            this.item.removeEnchantment(Enchantment.VANISHING_CURSE);
        }
        this.isItemDirty = true;
    }

    @Override
    public void setData(int data) {
        ItemMeta meta;
        if (this.data == data) {
            return;
        }
        this.data = data;
        if (this.isGhost()) {
            this.reconstructGhostModel();
        }
        if ((meta = this.item.getItemMeta()) == null) {
            return;
        }
        meta.setCustomModelData(Integer.valueOf(data));
        this.item.setItemMeta(meta);
        this.isItemDirty = true;
    }

    @Override
    public void createRealRenderer() {
        this.armorStand.createRealRenderer(this.bone.getActiveModel().getModeledEntity().getBase().getWorld(), this.isModelVisible ? this.item : empty);
    }

    @Override
    public UUID getRendererUUID() {
        return this.armorStand.getUuid();
    }

    private EulerAngle getBoneRotation() {
        if (this.isC) {
            return this.bone.getRotation();
        }
        EulerAngle rot = this.bone.getClientAproxRotation();
        if (rot != null) {
            return rot;
        }
        return this.bone.getRotation();
    }

    private boolean isGhost() {
        return this.rendererBone.isGhost() && this.item.getType() == Material.AIR;
    }

    private void reconstructGhostModel() {
        this.item = ModelEngineAPI.api.getGenerator().getBaseItemType().create();
        BaseItemEnum baseItemEnum = ModelEngineAPI.api.getGenerator().getBaseItemType();
        ItemMeta meta = this.item.getItemMeta();
        baseItemEnum.color(meta, this.color);
        this.item.setItemMeta(meta);
        if (this.isEnchant) {
            this.item.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        } else {
            this.item.removeEnchantment(Enchantment.VANISHING_CURSE);
        }
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

