/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_0_R1.network.interact;

import com.mojang.logging.LogUtils;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.SubHitbox;
import com.ticxo.modelengine.api.nms.entity.fake.SubHitboxEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class PatchedInteractHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void handleInteract(PacketPlayInUseEntity interactPacket, PacketListenerPlayIn listener) {
        int modelEntityId;
        net.minecraft.world.entity.Entity e;
        if (!(listener instanceof PlayerConnection)) {
            return;
        }
        final PlayerConnection connection = (PlayerConnection)listener;
        PlayerConnectionUtils.a((Packet)interactPacket, (PacketListener)connection, (WorldServer)connection.e().x());
        final EntityPlayer player = connection.e();
        final CraftPlayer craftPlayer = player.getBukkitEntity();
        assert (player.cE() != null);
        final CraftServer craftServer = player.cE().server;
        if (player.eF()) {
            return;
        }
        WorldServer worldServer = player.x();
        final net.minecraft.world.entity.Entity hitboxEntity = interactPacket.a(worldServer);
        if (hitboxEntity == player && !player.B_()) {
            connection.disconnect("Cannot interact with self!");
            return;
        }
        player.C();
        player.f(interactPacket.b());
        if (hitboxEntity == null) {
            return;
        }
        net.minecraft.world.entity.Entity relayedEntity = hitboxEntity;
        SubHitbox subHitbox = ModelEngineAPI.getModelTicker().getSubHitboxBone(hitboxEntity.cp());
        if (subHitbox != null && (e = worldServer.a(modelEntityId = subHitbox.getSubHitboxEntity().getRelayed().getEntityId())) != null && e != player) {
            relayedEntity = e;
        }
        if (!worldServer.p_().a(relayedEntity.db())) {
            return;
        }
        if (!PatchedInteractHandler.canInteract(player, hitboxEntity)) {
            return;
        }
        final net.minecraft.world.entity.Entity finalEntity = relayedEntity;
        interactPacket.a(new PacketPlayInUseEntity.c(){

            private void performInteraction(EnumHand enumhand, EntityInteraction interaction, PlayerInteractEntityEvent event) {
                ItemStack itemstack = player.b(enumhand).o();
                ItemStack itemInHand = player.b(enumhand);
                boolean triggerLeashUpdate = itemInHand != null && itemInHand.c() == Items.sG && finalEntity instanceof EntityInsentient;
                Item origItem = player.fB().f() == null ? null : player.fB().f().c();
                craftServer.getPluginManager().callEvent((Event)event);
                if (finalEntity instanceof Bucketable && finalEntity instanceof EntityLiving && origItem != null && origItem.l() == Items.oI && (event.isCancelled() || player.fB().f() == null || player.fB().f().c() != origItem)) {
                    connection.a((Packet)new PacketPlayOutSpawnEntity((EntityLiving)finalEntity));
                    player.bU.b();
                }
                if (triggerLeashUpdate && (event.isCancelled() || player.fB().f() == null || player.fB().f().c() != origItem)) {
                    connection.a((Packet)new PacketPlayOutAttachEntity(finalEntity, ((EntityInsentient)finalEntity).fA()));
                }
                if (event.isCancelled() || player.fB().f() == null || player.fB().f().c() != origItem) {
                    connection.a((Packet)new PacketPlayOutEntityMetadata(finalEntity.ae(), finalEntity.ai(), true));
                }
                if (!event.isCancelled()) {
                    EnumInteractionResult enuminteractionresult = interaction.run(player, finalEntity, enumhand);
                    if (itemInHand != null && !itemInHand.b() && itemInHand.K() <= -1) {
                        player.bU.b();
                    }
                    if (enuminteractionresult.a()) {
                        CriterionTriggers.Q.a(player, itemstack, finalEntity);
                        if (enuminteractionresult.b()) {
                            player.a(enumhand, true);
                        }
                    }
                }
            }

            public void a(EnumHand enumhand) {
                if (finalEntity instanceof SubHitboxEntity) {
                    SubHitboxEntity hitbox = (SubHitboxEntity)finalEntity;
                    hitbox.onFakeInteract((Player)craftPlayer, enumhand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                    return;
                }
                if (hitboxEntity instanceof SubHitboxEntity) {
                    SubHitboxEntity hitbox = (SubHitboxEntity)hitboxEntity;
                    hitbox.onRealInteract((Player)craftPlayer, enumhand == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND);
                }
                this.performInteraction(enumhand, EntityHuman::a, new PlayerInteractEntityEvent((Player)craftPlayer, (Entity)finalEntity.getBukkitEntity(), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
            }

            public void a(EnumHand enumhand, Vec3D vec3d) {
                if (finalEntity instanceof SubHitboxEntity) {
                    return;
                }
                this.performInteraction(enumhand, (entityplayer, entity1, enumhand1) -> entity1.a((EntityHuman)entityplayer, vec3d, enumhand1), (PlayerInteractEntityEvent)new PlayerInteractAtEntityEvent((Player)craftPlayer, (Entity)finalEntity.getBukkitEntity(), new Vector(vec3d.c, vec3d.d, vec3d.e), enumhand == EnumHand.b ? EquipmentSlot.OFF_HAND : EquipmentSlot.HAND));
            }

            public void a() {
                if (!(hitboxEntity instanceof EntityItem || hitboxEntity instanceof EntityExperienceOrb || hitboxEntity instanceof EntityArrow || hitboxEntity == player && !player.B_())) {
                    ItemStack itemInHand = player.eA();
                    player.d(hitboxEntity);
                    if (!itemInHand.b() && itemInHand.K() <= -1) {
                        player.bU.b();
                    }
                } else {
                    connection.disconnect(CraftChatMessage.fromComponent((IChatBaseComponent)IChatBaseComponent.c((String)"multiplayer.disconnect.invalid_entity_attacked")));
                    LOGGER.warn("Player {} tried to attack an invalid entity", (Object)player.X().getString());
                }
            }
        });
    }

    private static boolean canInteract(EntityPlayer player, net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB aabb = entity.cz();
        Vec3D delta = player.bk().d(aabb.f());
        Vector q = new Vector(Math.max(Math.abs(delta.c) - aabb.b() / 2.0, 0.0), Math.max(Math.abs(delta.d) - aabb.c() / 2.0, 0.0), Math.max(Math.abs(delta.e) - aabb.d() / 2.0, 0.0));
        return q.lengthSquared() < 36.0;
    }

    private static boolean canInteractDir(EntityPlayer player, net.minecraft.world.entity.Entity entity) {
        AxisAlignedBB aabb = entity.cz();
        return TMath.isBoundingBoxWithinDistance(new Vector(player.dg(), player.dk(), player.dm()), PatchedInteractHandler.getDirection(player), new BoundingBox(aabb.a, aabb.b, aabb.c, aabb.d, aabb.e, aabb.f), 6.0);
    }

    private static Vector getDirection(EntityPlayer player) {
        Vector vector = new Vector();
        double rotX = player.ch();
        double rotY = player.dt();
        vector.setY(-Math.sin(Math.toRadians(rotY)));
        double xz = Math.cos(Math.toRadians(rotY));
        vector.setX(-xz * Math.sin(Math.toRadians(rotX)));
        vector.setZ(xz * Math.cos(Math.toRadians(rotX)));
        return vector;
    }

    @FunctionalInterface
    private static interface EntityInteraction {
        public EnumInteractionResult run(EntityPlayer var1, net.minecraft.world.entity.Entity var2, EnumHand var3);
    }
}

