/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_0_R1.network;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.protocol.Packet;

public class PacketInterceptor {
    private final Map<Class<? extends Packet<?>>, PacketModifier<?>> registry = Maps.newConcurrentMap();
    private final Map<Class<? extends Packet<?>>, PacketListener<?>> postRegistry = Maps.newConcurrentMap();

    public <T extends Packet<?>> PacketInterceptor register(Class<T> clazz, Function<T, Packet<?>> function) {
        this.registry.put(clazz, new PacketModifier<T>(clazz, function));
        return this;
    }

    public <T extends Packet<?>> PacketInterceptor registerPost(Class<T> clazz, Consumer<T> consumer) {
        this.postRegistry.put(clazz, new PacketListener<T>(clazz, consumer));
        return this;
    }

    public Packet<?> accept(Packet<?> original) {
        PacketModifier<?> modifier = this.registry.get(original.getClass());
        return modifier == null ? original : modifier.modify(original);
    }

    public void acceptPost(Packet<?> original) {
        PacketListener<?> listener = this.postRegistry.get(original.getClass());
        if (listener != null) {
            listener.listen(original);
        }
    }

    private record PacketModifier<T extends Packet<?>>(Class<T> clazz, Function<T, Packet<?>> function) {
        public Packet<?> modify(Packet<?> original) {
            return this.function.apply((Packet)this.clazz.cast(original));
        }
    }

    private record PacketListener<T extends Packet<?>>(Class<T> clazz, Consumer<T> consumer) {
        public void listen(Packet<?> original) {
            this.consumer.accept((Packet)this.clazz.cast(original));
        }
    }
}

