/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_0_R1.entity.fake.hitbox;

import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_19_0_R1.entity.fake.FakeSlime;
import com.ticxo.modelengine.nms.v1_19_0_R1.network.NetworkUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ModelHitboxImpl
implements ModelHitbox {
    private final BaseEntity<?> baseEntity;
    private final Supplier<Hitbox> hitboxSupplier;
    private final Supplier<Vector> locationSupplier;
    private RangeManager rangeManager;
    private final List<FakeSlime> hitboxStack = new ArrayList<FakeSlime>();
    private final List<Packet<?>> stackOrder = new ArrayList();
    private PacketPlayOutEntityDestroy despawnPacket;

    public ModelHitboxImpl(BaseEntity<?> baseEntity) {
        this(baseEntity, baseEntity::getHitbox, () -> baseEntity.getLocation().toVector());
    }

    @Override
    public void refresh() {
        this.hitboxStack.clear();
        this.stackOrder.clear();
        this.rangeManager = this.baseEntity.getRangeManager();
        Hitbox hitbox = this.hitboxSupplier.get();
        Vector location = this.locationSupplier.get();
        int size = Math.max(TMath.biasRound(hitbox.getWidth() / 0.5202, 0.2), 1);
        FakeSlime base = new FakeSlime(location.getX(), location.getY(), location.getZ());
        base.setSize(size);
        this.hitboxStack.add(base);
        double sizedWidth = 0.5202 * (double)size;
        double slimeHeight = sizedWidth * 0.75;
        int count = TMath.biasRound((hitbox.getHeight() - sizedWidth) / slimeHeight, 0.2);
        for (int i = 0; i < count; ++i) {
            FakeSlime stack = new FakeSlime(location.getX(), location.getY(), location.getZ());
            stack.setSize(size);
            this.stackOrder.add((Packet<?>)this.hitboxStack.get(this.hitboxStack.size() - 1).addPassenger(stack.getEntityId()));
            this.hitboxStack.add(stack);
        }
        int[] ids = new int[this.hitboxStack.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = this.hitboxStack.get(i).getEntityId();
        }
        this.despawnPacket = new PacketPlayOutEntityDestroy(ids);
    }

    @Override
    public void spawn() {
        ArrayList packets = new ArrayList();
        Vector location = this.locationSupplier.get();
        for (FakeSlime slime : this.hitboxStack) {
            slime.getLocation().zero().add(location);
            packets.add((Packet<?>)slime.spawn());
            packets.add((Packet<?>)slime.meta());
        }
        packets.addAll(this.stackOrder);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), packets);
    }

    @Override
    public void spawn(Player player) {
        ArrayList packets = new ArrayList();
        Vector location = this.locationSupplier.get();
        for (FakeSlime slime : this.hitboxStack) {
            slime.getLocation().zero().add(location);
            packets.add((Packet<?>)slime.spawn());
            packets.add((Packet<?>)slime.meta());
        }
        packets.addAll(this.stackOrder);
        NetworkUtils.send(player, packets);
    }

    @Override
    public void despawn() {
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{this.despawnPacket});
    }

    @Override
    public void despawn(Player player) {
        NetworkUtils.send(player, new Packet[]{this.despawnPacket});
    }

    @Override
    public void update() {
        if (this.hitboxStack.isEmpty()) {
            return;
        }
        FakeSlime base = this.hitboxStack.get(0);
        PacketPlayOutEntityTeleport packet = base.updatePositionCalibrated(this.locationSupplier.get());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{packet});
    }

    public ModelHitboxImpl(BaseEntity<?> baseEntity, Supplier<Hitbox> hitboxSupplier, Supplier<Vector> locationSupplier) {
        this.baseEntity = baseEntity;
        this.hitboxSupplier = hitboxSupplier;
        this.locationSupplier = locationSupplier;
    }

    @Override
    public BaseEntity<?> getBaseEntity() {
        return this.baseEntity;
    }
}

