/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_0_R1.entity.fake.bone;

import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.NametagPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_19_0_R1.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_19_0_R1.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_19_0_R1.network.NetworkUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class NametagPointImplB
implements NametagPoint {
    private String customName;
    private boolean customNameVisible;
    private ModelBone bone;
    private RangeManager rangeManager;
    private FakeAreaEffectCloud cloud;
    private FakeArmorStand armorStand;
    private boolean isInitialized = false;

    public NametagPointImplB(ModelBone bone) {
        this.setBone(bone);
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.cloud = new FakeAreaEffectCloud(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand = new FakeArmorStand(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setInvisible(true);
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn();
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutMount mount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudSpawn, cloudMeta, armorSpawn, armorMeta, mount});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn();
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutMount mount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.send(player, new Packet[]{cloudSpawn, cloudMeta, armorSpawn, armorMeta, mount});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        Vector pos = this.bone.getPosition();
        this.armorStand.getLocation().zero().add(pos);
        PacketPlayOutEntityTeleport cloudPosition = this.cloud.updatePosition(pos);
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(false);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudPosition, armorMeta});
    }

    @Override
    public void setCustomName(String name) {
        if (this.customName != null && this.customName.equals(name)) {
            return;
        }
        this.customName = name;
        this.armorStand.setCustomName(name);
    }

    @Override
    public void setCustomNameVisible(boolean flag) {
        this.customNameVisible = flag;
        this.armorStand.setCustomNameVisible(flag);
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public boolean isCustomNameVisible() {
        return this.customNameVisible;
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

