/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_19_0_R1.entity.controller;

import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.utils.math.TMath;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;

@CommandAccessible(value={BodyRotationController.class})
public class BodyRotationControlWrapper
extends EntityAIBodyControl
implements BodyRotationController {
    private final EntityInsentient mob;
    private boolean isHeadClampUneven;
    private boolean isBodyClampUneven;
    private float maxHeadAngle;
    private float maxBodyAngle;
    private float minHeadAngle;
    private float minBodyAngle;
    private boolean playerMode;
    private float stableAngle = 15.0f;
    private int rotationDelay = 10;
    private int rotationDuration = 10;
    private int headStableTime;
    private float lastStableYHeadRot;

    public BodyRotationControlWrapper(EntityInsentient mob) {
        super(mob);
        this.mob = mob;
        this.maxHeadAngle = mob.V();
        this.maxBodyAngle = mob.V();
        this.minHeadAngle = -this.maxHeadAngle;
        this.minBodyAngle = -this.minBodyAngle;
    }

    public void a() {
        if (this.isMoving()) {
            this.mob.aX = this.mob.dr();
            this.rotateHeadIfNecessary();
            this.lastStableYHeadRot = this.mob.aZ;
            this.headStableTime = 0;
        } else if (this.notCarryingMobPassengers()) {
            if (Math.abs(this.mob.aZ - this.lastStableYHeadRot) > this.stableAngle) {
                this.headStableTime = 0;
                this.lastStableYHeadRot = this.mob.aZ;
                this.rotateBodyIfNecessary();
            } else if (!this.playerMode) {
                ++this.headStableTime;
                if (this.headStableTime > this.rotationDelay) {
                    this.rotateHeadTowardsFront();
                }
            }
        }
    }

    @Override
    public void setYHeadRot(float rot) {
        this.mob.aZ = rot;
    }

    @Override
    public float getYHeadRot() {
        return this.mob.aZ;
    }

    @Override
    public float getXHeadRot() {
        return this.mob.dt();
    }

    @Override
    public void setYBodyRot(float rot) {
        this.mob.aX = rot;
    }

    @Override
    public float getYBodyRot() {
        return this.mob.aX;
    }

    private void rotateBodyIfNecessary() {
        this.mob.aX = TMath.rotateIfNecessary(this.mob.aX, this.mob.aZ, this.isBodyClampUneven ? this.minBodyAngle : -this.maxBodyAngle, this.maxBodyAngle);
    }

    private void rotateHeadIfNecessary() {
        this.mob.aZ = TMath.rotateIfNecessary(this.mob.aZ, this.mob.aX, this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle, this.maxHeadAngle);
    }

    private void rotateHeadTowardsFront() {
        float ratio = (float)(this.headStableTime - this.rotationDelay) / (float)this.rotationDuration;
        float clampedRatio = TMath.clamp(ratio, 0.0f, 1.0f);
        float maxClamp = this.maxHeadAngle * (1.0f - clampedRatio);
        float minClamp = (this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle) * (1.0f - clampedRatio);
        this.mob.aX = TMath.rotateIfNecessary(this.mob.aX, this.mob.aZ, minClamp, maxClamp);
    }

    private boolean notCarryingMobPassengers() {
        return !(this.mob.cK() instanceof EntityInsentient);
    }

    private boolean isMoving() {
        double dZ;
        double dX = this.mob.dg() - this.mob.t;
        return dX * dX + (dZ = this.mob.dm() - this.mob.v) * dZ > 2.500000277905201E-7;
    }

    @Override
    public boolean isHeadClampUneven() {
        return this.isHeadClampUneven;
    }

    @Override
    public void setHeadClampUneven(boolean isHeadClampUneven) {
        this.isHeadClampUneven = isHeadClampUneven;
    }

    @Override
    public boolean isBodyClampUneven() {
        return this.isBodyClampUneven;
    }

    @Override
    public void setBodyClampUneven(boolean isBodyClampUneven) {
        this.isBodyClampUneven = isBodyClampUneven;
    }

    @Override
    public float getMaxHeadAngle() {
        return this.maxHeadAngle;
    }

    @Override
    public void setMaxHeadAngle(float maxHeadAngle) {
        this.maxHeadAngle = maxHeadAngle;
    }

    @Override
    public float getMaxBodyAngle() {
        return this.maxBodyAngle;
    }

    @Override
    public void setMaxBodyAngle(float maxBodyAngle) {
        this.maxBodyAngle = maxBodyAngle;
    }

    @Override
    public float getMinHeadAngle() {
        return this.minHeadAngle;
    }

    @Override
    public void setMinHeadAngle(float minHeadAngle) {
        this.minHeadAngle = minHeadAngle;
    }

    @Override
    public float getMinBodyAngle() {
        return this.minBodyAngle;
    }

    @Override
    public void setMinBodyAngle(float minBodyAngle) {
        this.minBodyAngle = minBodyAngle;
    }

    @Override
    public boolean isPlayerMode() {
        return this.playerMode;
    }

    @Override
    public void setPlayerMode(boolean playerMode) {
        this.playerMode = playerMode;
    }

    @Override
    public float getStableAngle() {
        return this.stableAngle;
    }

    @Override
    public void setStableAngle(float stableAngle) {
        this.stableAngle = stableAngle;
    }

    @Override
    public int getRotationDelay() {
        return this.rotationDelay;
    }

    @Override
    public void setRotationDelay(int rotationDelay) {
        this.rotationDelay = rotationDelay;
    }

    @Override
    public int getRotationDuration() {
        return this.rotationDuration;
    }

    @Override
    public void setRotationDuration(int rotationDuration) {
        this.rotationDuration = rotationDuration;
    }
}

