/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.network;

import com.google.common.collect.Maps;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.nms.network.NetworkHandler;
import com.ticxo.modelengine.nms.v1_18_R2.network.ModelEngineChannelHandler;
import com.ticxo.modelengine.nms.v1_18_R2.network.NetworkUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.NetworkManager;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class NetworkHandlerImpl
implements NetworkHandler {
    private final Map<UUID, ChannelPipeline> pipelines = Maps.newConcurrentMap();

    public NetworkHandlerImpl() {
        ModelEngineAPI.getConfigManager().registerReferenceUpdate(NetworkUtils::updateConfigs);
    }

    @Override
    public ChannelPipeline getPipeline(Player player) {
        return this.pipelines.get(player.getUniqueId());
    }

    @Override
    public void removePipeline(Player player) {
        this.pipelines.remove(player.getUniqueId());
    }

    @Override
    public void injectChannel(Player player) {
        ModelEngineChannelHandler handler = new ModelEngineChannelHandler(player);
        ChannelPipeline pipeline = ((CraftPlayer)player).getHandle().b.a().m.pipeline();
        this.pipelines.put(player.getUniqueId(), pipeline);
        for (String name : pipeline.toMap().keySet()) {
            if (!(pipeline.get(name) instanceof NetworkManager)) continue;
            pipeline.addBefore(name, "model_engine_packet_handler", (ChannelHandler)handler);
            break;
        }
    }

    @Override
    public void ejectChannel(Player player) {
        Channel channel = ((CraftPlayer)player).getHandle().b.a().m;
        channel.eventLoop().submit(() -> {
            channel.pipeline().remove("model_engine_packet_handler");
            return null;
        });
        this.removePipeline(player);
    }
}

