/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity.range;

import com.google.common.collect.ImmutableSet;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.nms.v1_18_R2.NMSFields;
import com.ticxo.modelengine.nms.v1_18_R2.network.NetworkUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class RangeManagerImpl
implements RangeManager {
    private final Supplier<PlayerChunkMap.EntityTracker> instanceSupplier;
    private PlayerChunkMap.EntityTracker tracked;
    private EntityTrackerEntry entity;
    private int renderDistance;

    public RangeManagerImpl(Supplier<PlayerChunkMap.EntityTracker> tracked) {
        this.instanceSupplier = tracked;
        this.getInstance();
    }

    protected void getInstance() {
        if (this.tracked != null) {
            return;
        }
        this.tracked = this.instanceSupplier.get();
        if (this.tracked == null) {
            return;
        }
        try {
            this.entity = (EntityTrackerEntry)FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_serverEntity).get(this.tracked);
            this.renderDistance = FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_range).getInt(this.tracked);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void forceSpawn(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        this.entity.sendPairingData(packet -> {
            Integer id = EnumProtocol.b.a(EnumProtocolDirection.b, packet);
            if (id == null) {
                nmsPlayer.b.a(packet);
            }
            NetworkUtils.send(player, packet);
        }, nmsPlayer);
    }

    @Override
    public void updatePlayer(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.tracked.b(((CraftPlayer)player).getHandle());
    }

    @Override
    public void removePlayer(Player player) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.tracked.a(((CraftPlayer)player).getHandle());
    }

    @Override
    public void setRenderDistance(int radius) {
        this.getInstance();
        if (this.tracked == null) {
            return;
        }
        this.renderDistance = radius;
        try {
            FieldUtils.getField(PlayerChunkMap.EntityTracker.class, NMSFields.TRACKEDENTITY_range).setInt(this.tracked, radius);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Set<Player> getPlayerInRange() {
        this.getInstance();
        if (this.tracked == null) {
            return ImmutableSet.of();
        }
        HashSet<Player> set = new HashSet<Player>();
        this.tracked.f.forEach(serverPlayerConnection -> set.add((Player)serverPlayerConnection.e().getBukkitEntity()));
        return set;
    }

    @Override
    public int getRenderDistance() {
        return this.renderDistance;
    }
}

