/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.MountPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_18_R2.network.NetworkUtils;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class MountPointImplAC
implements MountPoint {
    private final Set<Entity> passengers = Sets.newConcurrentHashSet();
    private ModelBone bone;
    private RangeManager rangeManager;
    private FakeArmorStand armorStand;
    private boolean isInitialized = false;
    private final boolean isC;

    public MountPointImplAC(ModelBone bone, boolean isC) {
        this.setBone(bone);
        this.isC = isC;
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.armorStand = new FakeArmorStand(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setInvisible(true);
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorSpawn, armorMeta, passengerMount});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(player, new Packet[]{armorSpawn, armorMeta, passengerMount});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        Packet<PacketListenerPlayOut> armorPosition = this.isC ? this.armorStand.updatePositionCalibrated(this.bone.getYaw(), this.bone.getPosition()) : this.armorStand.updatePosition(this.bone.getYaw(), this.bone.getPosition());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), armorPosition);
    }

    @Override
    public void addPassengers(Entity ... passengers) {
        this.passengers.addAll(Arrays.asList(passengers));
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{passengerMount});
    }

    @Override
    public void removePassengers(Entity ... passengers) {
        Arrays.asList(passengers).forEach(this.passengers::remove);
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{passengerMount});
    }

    @Override
    public void clearPassengers() {
        this.passengers.clear();
        PacketPlayOutMount passengerMount = this.armorStand.addPassengers(this.passengers);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{passengerMount});
    }

    @Override
    public Set<Entity> getPassengers() {
        return ImmutableSet.copyOf(this.passengers);
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

