/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.bone.ItemHolder;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.HandRenderer;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_18_R2.network.NetworkUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;

public class HandRendererImplAC
implements HandRenderer {
    private ModelBone bone;
    private ItemHolder itemBone;
    private RangeManager rangeManager;
    private FakeArmorStand armorStand;
    private ItemStack item;
    private boolean isItemDirty;
    private boolean isInitialized = false;
    private final boolean isC;

    public HandRendererImplAC(ModelBone bone, boolean isC) {
        this.setBone(bone);
        this.isC = isC;
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.itemBone = bone instanceof ItemHolder ? (ItemHolder)bone : null;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        FakeEntity.DisplaySlot displaySlot = this.itemBone.getDisplay();
        this.armorStand = new FakeArmorStand(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.armorStand.setRotation(this.getBoneRotation());
        this.armorStand.setInvisible(true);
        this.armorStand.setSmall(false);
        this.armorStand.setDisplay(displaySlot);
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.item);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorSpawn, armorMeta});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorEquip}));
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.bone.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.item);
        NetworkUtils.send(player, new Packet[]{armorSpawn, armorMeta});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(player, new Packet[]{armorEquip}));
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setRotation(this.getBoneRotation());
        Packet<PacketListenerPlayOut> armorPosition = this.isC ? this.armorStand.updatePositionCalibrated(this.bone.getYaw(), this.bone.getPosition()) : this.armorStand.updatePosition(this.bone.getYaw(), this.bone.getPosition());
        PacketPlayOutEntityMetadata armorPose = this.armorStand.updateMeta(false);
        PacketPlayOutEntityEquipment armorEquip = null;
        if (this.isItemDirty) {
            armorEquip = this.armorStand.updateEquipment(this.item);
            this.isItemDirty = false;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorPosition, armorPose, armorEquip});
    }

    @Override
    public void updateModel() {
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.item);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorEquip});
    }

    @Override
    public void setSmall(boolean flag) {
        this.armorStand.setSmall(flag);
    }

    @Override
    public void setModel(ItemStack item) {
        this.item = item;
        this.isItemDirty = true;
    }

    @Override
    public void setGlowing(boolean flag) {
        this.armorStand.setGlowing(flag);
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(false);
        if (armorMeta == null) {
            return;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorMeta});
    }

    @Override
    public void setDisplay(FakeEntity.DisplaySlot slot) {
        if (!this.isInitialized) {
            return;
        }
        this.armorStand.setDisplay(slot);
    }

    @Override
    public void createRealRenderer() {
        this.armorStand.createRealRenderer(this.bone.getActiveModel().getModeledEntity().getBase().getWorld(), this.item);
    }

    private EulerAngle getBoneRotation() {
        if (this.isC) {
            return this.bone.getRotation();
        }
        EulerAngle rot = this.bone.getClientAproxRotation();
        if (rot != null) {
            return rot;
        }
        return this.bone.getRotation();
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

