/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity.controller.special;

import com.ticxo.modelengine.api.animation.state.ModelState;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_18_R2.entity.controller.MoveControlWrapper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.phys.Vec3D;

public class VexMoveControlWrapper
extends MoveControlWrapper {
    private final EntityVex vex;

    public VexMoveControlWrapper(EntityVex mob, ControllerMove control, ModeledEntity model) {
        super((EntityInsentient)mob, control, model);
        this.vex = mob;
    }

    @Override
    protected void defaultTick() {
        ControllerMove.Operation operation = this.getOperation();
        switch (operation) {
            case a: {
                this.modeledEntity.setState(ModelState.IDLE);
                break;
            }
            case b: 
            case c: {
                this.modeledEntity.setState(ModelState.WALK);
                break;
            }
            case d: {
                this.modeledEntity.setState(ModelState.JUMP);
            }
        }
        if (operation == ControllerMove.Operation.b) {
            Vec3D delta = new Vec3D(this.d() - this.vex.dc(), this.e() - this.vex.de(), this.f() - this.vex.di());
            double distance = delta.f();
            boolean distanceCheck = distance < this.vex.cw().a();
            boolean isCharging = this.vex.fz();
            boolean isWantedWithinHitbox = this.vex.cw().e(this.d(), this.e(), this.f());
            if (distanceCheck && (!isCharging || isWantedWithinHitbox)) {
                operation = ControllerMove.Operation.a;
                this.vex.g(this.vex.da().a(0.5));
            } else {
                this.vex.g(this.vex.da().e(delta.a(this.c() * 0.05 / distance)));
                if (this.vex.G() == null) {
                    Vec3D vec3d1 = this.vex.da();
                    this.vex.o((float)TMath.fastAtan2(-vec3d1.b, vec3d1.d) * 57.295776f);
                } else {
                    double dX = this.vex.G().dc() - this.vex.dc();
                    double dZ = this.vex.G().di() - this.vex.di();
                    this.vex.o((float)TMath.fastAtan2(-dX, dZ) * 57.295776f);
                }
                this.vex.aX = this.vex.dn();
            }
        }
        this.setOperation(operation);
    }
}

