/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity.controller;

import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.mount.MountManager;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.utils.math.TMath;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.phys.Vec3D;

@CommandAccessible(value={LookController.class})
public class LookControlWrapper
extends ControllerLook
implements LookController {
    private final ModeledEntity modeledEntity;
    private final MountManager mountManager;
    private final ControllerLook original;

    public LookControlWrapper(EntityInsentient mob, ControllerLook control, ModeledEntity model) {
        super(mob);
        this.original = control;
        this.modeledEntity = model;
        this.mountManager = model.getMountManager();
    }

    public void a(Vec3D var0) {
        this.original.a(var0);
    }

    public void a(Entity var0) {
        this.original.a(var0);
    }

    public void a(Entity var0, float var1, float var2) {
        this.original.a(var0, var1, var2);
    }

    public void a(double var0, double var2, double var4) {
        this.original.a(var0, var2, var4);
    }

    public void a(double var0, double var2, double var4, float var6, float var7) {
        this.original.a(var0, var2, var4, var6, var7);
    }

    public void a() {
        if (this.mountManager != null && this.mountManager.isControlled()) {
            this.controlledTick();
        } else {
            this.defaultTick();
        }
    }

    protected void controlledTick() {
        MountController controller = this.mountManager.getDriverController();
        controller.updateDirection(this, this.modeledEntity);
    }

    protected void defaultTick() {
        this.original.a();
    }

    public boolean d() {
        return this.original.d();
    }

    public double e() {
        return this.original.e();
    }

    public double f() {
        return this.original.f();
    }

    public double g() {
        return this.original.g();
    }

    @Override
    public void lookAt(double x, double y, double z) {
        double dX = x - this.a.dc();
        double dY = y - this.a.dg();
        double dZ = z - this.a.di();
        double hMagnitude = TMath.fastSqrt(dX * dX + dZ * dZ);
        float pitch = (float)Math.toDegrees(TMath.fastAtan2(-dY, hMagnitude));
        float yaw = (float)Math.toDegrees(TMath.fastAtan2(-dX, dZ));
        this.setPitch(pitch);
        this.setHeadYaw(yaw);
    }

    @Override
    public void setPitch(float pitch) {
        this.a.p(pitch);
    }

    @Override
    public void setHeadYaw(float yaw) {
        this.a.o(yaw);
        this.a.aZ = yaw;
    }

    @Override
    public void setBodyYaw(float yaw) {
        this.a.aX = yaw;
    }
}

