/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R2.entity;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.generator.Hitbox;
import com.ticxo.modelengine.api.model.AnimationMode;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.nms.entity.EntityHandler;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.api.nms.entity.fake.DummyRangeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.HandRenderer;
import com.ticxo.modelengine.api.nms.entity.fake.LeashPoint;
import com.ticxo.modelengine.api.nms.entity.fake.MountPoint;
import com.ticxo.modelengine.api.nms.entity.fake.NametagPoint;
import com.ticxo.modelengine.api.nms.entity.fake.SubHitboxEntity;
import com.ticxo.modelengine.api.nms.entity.fake.VFXRenderer;
import com.ticxo.modelengine.api.nms.entity.hitbox.DynamicHitbox;
import com.ticxo.modelengine.api.nms.entity.hitbox.ModelHitbox;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyLookController;
import com.ticxo.modelengine.api.nms.entity.impl.EmptyMoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.nms.entity.wrapper.LookController;
import com.ticxo.modelengine.api.nms.entity.wrapper.MoveController;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.api.nms.world.IDamageSource;
import com.ticxo.modelengine.api.utils.FieldUtils;
import com.ticxo.modelengine.api.utils.logger.TLogger;
import com.ticxo.modelengine.nms.v1_18_R2.NMSFields;
import com.ticxo.modelengine.nms.v1_18_R2.NMSUtils;
import com.ticxo.modelengine.nms.v1_18_R2.entity.controller.BodyRotationControlWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.controller.LookControlWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.controller.MoveControlWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.controller.special.VexMoveControlWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.BoneRendererImplAC;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.BoneRendererImplB;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.HandRendererImplAC;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.HandRendererImplB;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.LeashPointImplAC;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.LeashPointImplB;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.MountPointImplAC;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.MountPointImplB;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.NametagPointImplAC;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.NametagPointImplB;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.bone.SubHitboxEntityImpl;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.hitbox.DynamicHitboxImpl;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.hitbox.ModelHitboxImpl;
import com.ticxo.modelengine.nms.v1_18_R2.entity.fake.vfx.VFXRendererImpl;
import com.ticxo.modelengine.nms.v1_18_R2.entity.navigation.FlyingNavigationWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.navigation.GroundNavigationWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.navigation.WallClimberNavigationWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.navigation.WaterBoundNavigationWrapper;
import com.ticxo.modelengine.nms.v1_18_R2.entity.range.DummyRangeEntityImpl;
import com.ticxo.modelengine.nms.v1_18_R2.entity.range.PlayerRangeManagerImpl;
import com.ticxo.modelengine.nms.v1_18_R2.entity.range.RangeManagerImpl;
import com.ticxo.modelengine.nms.v1_18_R2.network.NetworkUtils;
import com.ticxo.modelengine.nms.v1_18_R2.world.DamageSourceWrapper;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalSelector;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWrapped;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.navigation.NavigationSpider;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.monster.EntityVex;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftMob;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.Nullable;

public class EntityHandlerImpl
implements EntityHandler {
    private final DynamicHitbox dynamicHitbox;
    private AtomicInteger entityCounter;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final List<DataWatcher.Item<?>> commonDataList;

    public EntityHandlerImpl() {
        try {
            this.entityCounter = (AtomicInteger)FieldUtils.getField(net.minecraft.world.entity.Entity.class, NMSFields.ENTITY_ENTITY_COUNTER).get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dynamicHitbox = new DynamicHitboxImpl(this.entityCounter);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)0);
        this.commonDataList = List.of(this.commonDataItem);
    }

    @Override
    public void setHitbox(Entity entity, Hitbox hitbox) {
        if (hitbox == null) {
            return;
        }
        net.minecraft.world.entity.Entity nms = ((CraftEntity)entity).getHandle();
        try {
            EntitySize box = new EntitySize((float)hitbox.getMaxWidth(), (float)hitbox.getHeight(), true);
            FieldUtils.getField(net.minecraft.world.entity.Entity.class, NMSFields.ENTITY_dimensions).set(nms, box);
            FieldUtils.getField(net.minecraft.world.entity.Entity.class, NMSFields.ENTITY_eyeHeight).setFloat(nms, (float)hitbox.getEyeHeight());
            nms.a(box.a(nms.cV()));
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setStepHeight(Entity entity, double height) {
        ((CraftEntity)entity).getHandle().P = (float)height;
    }

    @Override
    public MoveController wrapMoveControl(Entity entity) {
        Mob mob;
        block8: {
            block7: {
                if (!(entity instanceof Mob)) break block7;
                mob = (Mob)entity;
                if (!(entity instanceof Slime)) break block8;
            }
            return new EmptyMoveController();
        }
        EntityInsentient nmsMob = ((CraftMob)mob).getHandle();
        try {
            MoveControlWrapper newController;
            ControllerMove moveControl = nmsMob.A();
            ModeledEntity model = ModelEngineAPI.getModeledEntity(entity.getUniqueId());
            if (nmsMob instanceof EntityVex) {
                EntityVex vex = (EntityVex)nmsMob;
                newController = new VexMoveControlWrapper(vex, moveControl, model);
            } else {
                newController = new MoveControlWrapper(nmsMob, moveControl, model);
            }
            FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_moveControl).set(nmsMob, newController);
            return newController;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new EmptyMoveController();
        }
    }

    @Override
    public LookController wrapLookControl(Entity entity) {
        if (!(entity instanceof Mob)) {
            return new EmptyLookController();
        }
        Mob mob = (Mob)entity;
        EntityInsentient nmsMob = ((CraftMob)mob).getHandle();
        try {
            ControllerLook lookControl = nmsMob.z();
            ModeledEntity model = ModelEngineAPI.getModeledEntity(entity.getUniqueId());
            LookControlWrapper newController = new LookControlWrapper(nmsMob, lookControl, model);
            FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_lookControl).set(nmsMob, newController);
            return newController;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return new EmptyLookController();
        }
    }

    @Override
    @Nullable
    public BodyRotationController wrapBodyRotationControl(Entity entity) {
        if (!(entity instanceof Mob)) {
            return null;
        }
        Mob mob = (Mob)entity;
        EntityInsentient nmsMob = ((CraftMob)mob).getHandle();
        try {
            BodyRotationControlWrapper newController = new BodyRotationControlWrapper(nmsMob);
            FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_bodyRotationControl).set(nmsMob, newController);
            return newController;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void wrapNavigation(Entity entity) {
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entity;
        EntityInsentient nmsMob = ((CraftMob)mob).getHandle();
        try {
            Object newNav;
            Field navField = FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_navigation);
            NavigationAbstract oldNav = nmsMob.D();
            if (oldNav instanceof NavigationSpider) {
                NavigationSpider wallClimberNavigation = (NavigationSpider)oldNav;
                newNav = new WallClimberNavigationWrapper(nmsMob, wallClimberNavigation);
            } else if (oldNav instanceof Navigation) {
                Navigation groundPathNavigation = (Navigation)oldNav;
                newNav = new GroundNavigationWrapper(nmsMob, groundPathNavigation);
            } else if (oldNav instanceof NavigationFlying) {
                NavigationFlying flyingPathNavigation = (NavigationFlying)oldNav;
                newNav = new FlyingNavigationWrapper(nmsMob, flyingPathNavigation);
            } else if (oldNav instanceof NavigationGuardian) {
                newNav = new WaterBoundNavigationWrapper(nmsMob);
            } else {
                TLogger.error("Failed to create custom navigation for " + mob.getType() + ": " + mob.getUniqueId());
                TLogger.error("Reason: Navigation class type is " + oldNav.getClass().getSimpleName() + ".");
                return;
            }
            navField.set(nmsMob, newNav);
            PathfinderGoalSelector goalSelector = (PathfinderGoalSelector)FieldUtils.getField(EntityInsentient.class, NMSFields.MOB_goalSelector).get(nmsMob);
            for (PathfinderGoalWrapped wrappedGoal : goalSelector.c()) {
                PathfinderGoal goal = wrappedGoal.k();
                for (Field field : goal.getClass().getDeclaredFields()) {
                    field = FieldUtils.getField(goal.getClass(), field.getName());
                    Object f = field.get(goal);
                    if (!(f instanceof NavigationAbstract)) continue;
                    field.set(goal, newNav);
                }
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public RangeManager wrapRangeManager(Entity entity) {
        WorldServer level = ((CraftWorld)entity.getWorld()).getHandle();
        Int2ObjectMap map = level.k().a.J;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return new PlayerRangeManagerImpl(player, () -> (PlayerChunkMap.EntityTracker)map.get(entity.getEntityId()));
        }
        return new RangeManagerImpl(() -> (PlayerChunkMap.EntityTracker)map.get(entity.getEntityId()));
    }

    @Override
    public boolean hurt(Entity entity, IDamageSource damageSource, float damage) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        DamageSource nmsDamageSource = ((DamageSourceWrapper)damageSource).getOriginal();
        return nmsEntity.a(nmsDamageSource, damage);
    }

    @Override
    public void interact(Entity entity, Player player, EquipmentSlot hand) {
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        nmsEntity.a((EntityHuman)nmsPlayer, hand == EquipmentSlot.HAND ? EnumHand.a : EnumHand.b);
    }

    @Override
    public BoneRenderer createBoneRenderer(ModelBone bone) {
        return switch (bone.getActiveModel().getAnimationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationMode.A -> new BoneRendererImplAC(bone, false);
            case AnimationMode.B -> new BoneRendererImplB(bone);
            case AnimationMode.C -> new BoneRendererImplAC(bone, true);
        };
    }

    @Override
    public MountPoint createMountPoint(ModelBone bone) {
        return switch (bone.getActiveModel().getAnimationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationMode.A -> new MountPointImplAC(bone, false);
            case AnimationMode.B -> new MountPointImplB(bone);
            case AnimationMode.C -> new MountPointImplAC(bone, true);
        };
    }

    @Override
    public NametagPoint createNametagPoint(ModelBone bone) {
        return switch (bone.getActiveModel().getAnimationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationMode.A -> new NametagPointImplAC(bone, false);
            case AnimationMode.B -> new NametagPointImplB(bone);
            case AnimationMode.C -> new NametagPointImplAC(bone, true);
        };
    }

    @Override
    public LeashPoint createLeashPoint(ModelBone bone) {
        return switch (bone.getActiveModel().getAnimationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationMode.A -> new LeashPointImplAC(bone, false);
            case AnimationMode.B -> new LeashPointImplB(bone);
            case AnimationMode.C -> new LeashPointImplAC(bone, true);
        };
    }

    @Override
    public SubHitboxEntity createSubHitboxEntity(ModelBone bone) {
        World world = bone.getActiveModel().getModeledEntity().getBase().getWorld();
        WorldServer level = ((CraftWorld)world).getHandle();
        SubHitboxEntityImpl hitbox = new SubHitboxEntityImpl((net.minecraft.world.level.World)level);
        level.n().c(() -> hitbox.onLevelSync(bone));
        return hitbox;
    }

    @Override
    public HandRenderer createHandRenderer(ModelBone bone) {
        return switch (bone.getActiveModel().getAnimationMode()) {
            default -> throw new IncompatibleClassChangeError();
            case AnimationMode.A -> new HandRendererImplAC(bone, false);
            case AnimationMode.B -> new HandRendererImplB(bone);
            case AnimationMode.C -> new HandRendererImplAC(bone, true);
        };
    }

    @Override
    public VFXRenderer createVFXRenderer(VFX vfx) {
        return new VFXRendererImpl(vfx);
    }

    @Override
    public DummyRangeEntity createDummyRangeEntity(BaseEntity<?> entity) {
        return new DummyRangeEntityImpl(entity);
    }

    @Override
    public ModelHitbox createModelHitbox(BaseEntity<?> entity) {
        return new ModelHitboxImpl(entity);
    }

    @Override
    public void broadcastSpawnPacket(BaseEntity<?> entity, boolean excludeSelf) {
        Set<Player> playerSet;
        RangeManager rangeManager = entity.getRangeManager();
        if (excludeSelf && rangeManager instanceof RangeManager.Disguise) {
            RangeManager.Disguise disguiseRangeManager = (RangeManager.Disguise)((Object)rangeManager);
            playerSet = disguiseRangeManager.getViewers();
        } else {
            playerSet = rangeManager.getPlayerInRange();
        }
        for (Player player : playerSet) {
            rangeManager.forceSpawn(player);
        }
    }

    @Override
    public void broadcastDespawnPacket(BaseEntity<?> entity, boolean excludeSelf) {
        PacketPlayOutEntityDestroy removeEntitiesPacket = new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()});
        RangeManager rangeManager = entity.getRangeManager();
        if (rangeManager == null) {
            return;
        }
        if (excludeSelf && rangeManager instanceof RangeManager.Disguise) {
            RangeManager.Disguise disguiseRangeManager = (RangeManager.Disguise)((Object)rangeManager);
            NetworkUtils.send(disguiseRangeManager.getViewers(), new Packet[]{removeEntitiesPacket});
        } else {
            NetworkUtils.send(rangeManager.getPlayerInRange(), new Packet[]{removeEntitiesPacket});
        }
    }

    @Override
    public void hideBoundSubHitboxEntity(ModeledEntity model, Entity entity) {
        RangeManager boundRangeManager = this.wrapRangeManager(entity);
        boundRangeManager.setRenderDistance(0);
        PacketPlayOutEntityDestroy removeEntitiesPacket = new PacketPlayOutEntityDestroy(new int[]{entity.getEntityId()});
        RangeManager modelRangeManager = model.getRangeManager();
        NetworkUtils.send(modelRangeManager.getPlayerInRange(), new Packet[]{removeEntitiesPacket});
    }

    @Override
    public void setSelfFakeInvisible(Player player, boolean flag) {
        EntityPlayer nmsPlayer = ((CraftPlayer)player).getHandle();
        byte flags = (Byte)nmsPlayer.ai().a(DataAccessors.COMMON_DATA);
        byte bit = flag ? NMSUtils.setBit(flags, 5, true) : flags;
        this.commonDataItem.a((Object)bit);
        PacketDataSerializer byteBuf = NetworkUtils.createByteBuf();
        byteBuf.d(player.getEntityId());
        DataWatcher.a(this.commonDataList, (PacketDataSerializer)byteBuf);
        PacketPlayOutEntityMetadata meta = new PacketPlayOutEntityMetadata(byteBuf);
        NetworkUtils.send(player, new Packet[]{meta});
    }

    @Override
    public void setYHeadRot(Entity entity, float rot) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        EntityLiving nmsMob = ((CraftLivingEntity)mob).getHandle();
        if (nmsMob instanceof EntityArmorStand) {
            nmsMob.o(rot);
            return;
        }
        nmsMob.aZ = rot;
    }

    @Override
    public void setYBodyRot(Entity entity, float rot) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity mob = (LivingEntity)entity;
        EntityLiving nmsMob = ((CraftLivingEntity)mob).getHandle();
        nmsMob.aX = rot;
    }

    @Override
    public float getYHeadRot(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity mob = (LivingEntity)entity;
        EntityLiving nmsMob = ((CraftLivingEntity)mob).getHandle();
        return nmsMob.getBukkitYaw();
    }

    @Override
    public float getXHeadRot(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity mob = (LivingEntity)entity;
        EntityLiving nmsMob = ((CraftLivingEntity)mob).getHandle();
        return nmsMob.do();
    }

    @Override
    public float getYBodyRot(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return 0.0f;
        }
        LivingEntity mob = (LivingEntity)entity;
        EntityLiving nmsMob = ((CraftLivingEntity)mob).getHandle();
        return nmsMob.aX;
    }

    @Override
    public boolean isMoving(Entity entity) {
        double dZ;
        net.minecraft.world.entity.Entity nmsEntity = ((CraftEntity)entity).getHandle();
        double dX = nmsEntity.dc() - nmsEntity.M;
        return dX * dX + (dZ = nmsEntity.di() - nmsEntity.O) * dZ > 2.500000277905201E-7;
    }

    @Override
    public DynamicHitbox getDynamicHitbox() {
        return this.dynamicHitbox;
    }

    @Override
    public AtomicInteger getEntityCounter() {
        return this.entityCounter;
    }
}

