/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R1.network;

import com.google.common.collect.Sets;
import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import com.ticxo.modelengine.api.model.mananger.ModelTicker;
import com.ticxo.modelengine.api.model.mananger.VFXTicker;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.mount.controller.MountController;
import com.ticxo.modelengine.api.nms.entity.fake.BoneRenderer;
import com.ticxo.modelengine.nms.v1_18_R1.network.NetworkUtils;
import com.ticxo.modelengine.nms.v1_18_R1.network.PacketInterceptor;
import com.ticxo.modelengine.nms.v1_18_R1.network.interact.ServerboundInteractPacketWrapper;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.level.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class ModelEngineChannelHandler
extends ChannelDuplexHandler {
    private final Player bukkit;
    private final EntityPlayer player;
    private final ModelTicker ticker;
    private final VFXTicker vfxTicker;
    private final PacketInterceptor writeInterceptors;
    private final PacketInterceptor readInterceptors;

    public ModelEngineChannelHandler(Player player) {
        this.bukkit = player;
        this.player = ((CraftPlayer)player).getHandle();
        this.ticker = ModelEngineAPI.getModelTicker();
        this.vfxTicker = ModelEngineAPI.getVFXTicker();
        this.writeInterceptors = new PacketInterceptor().register(PacketPlayOutSpawnEntity.class, this::handleAddEntity).register(PacketPlayOutSpawnEntityLiving.class, this::handleAddMob).register(PacketPlayOutNamedEntitySpawn.class, this::handleAddPlayer).register(PacketPlayOutEntityDestroy.class, this::handleRemoveEntities).register(PacketPlayOutScoreboardTeam.class, this::handleSetPlayerTeam).register(PacketPlayOutEntityMetadata.class, this::handleSetEntityData);
        this.readInterceptors = new PacketInterceptor().register(PacketPlayInSteerVehicle.class, this::handlePlayerInput).register(PacketPlayInUseEntity.class, this::handleInteract);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!(msg instanceof Packet)) {
            super.write(ctx, (Object)msg, promise);
            return;
        }
        Packet packet = (Packet)msg;
        msg = this.writeInterceptors.accept(packet);
        if (msg == null) {
            return;
        }
        super.write(ctx, msg, promise);
        this.writeInterceptors.acceptPost(packet);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof Packet)) {
            super.channelRead(ctx, (Object)msg);
            return;
        }
        Packet packet = (Packet)msg;
        msg = this.readInterceptors.accept(packet);
        if (msg == null) {
            return;
        }
        super.channelRead(ctx, msg);
        this.readInterceptors.acceptPost(packet);
    }

    private boolean showModel(int id) {
        VFX vfx;
        boolean shouldClear = false;
        ModeledEntity model = this.ticker.getModeledEntity(id);
        if (model != null) {
            model.showToPlayer(this.bukkit);
            boolean bl = shouldClear = !model.isBaseEntityVisible();
        }
        if ((vfx = this.vfxTicker.getVFX(id)) != null) {
            vfx.showToPlayer(this.bukkit);
            shouldClear |= !vfx.isBaseEntityVisible();
        }
        return shouldClear;
    }

    private boolean showModel(UUID id) {
        VFX vfx;
        boolean shouldClear = false;
        ModeledEntity model = this.ticker.getModeledEntity(id);
        if (model != null) {
            model.showToPlayer(this.bukkit);
            boolean bl = shouldClear = !model.isBaseEntityVisible();
        }
        if ((vfx = this.vfxTicker.getVFX(id)) != null) {
            vfx.showToPlayer(this.bukkit);
            shouldClear |= !vfx.isBaseEntityVisible();
        }
        return shouldClear;
    }

    private void hideModel(int id) {
        VFX vfx;
        ModeledEntity model = this.ticker.getModeledEntity(id);
        if (model != null && (!model.getBase().isDead() || model.getBase().isDead() && model.getAnimationState(false))) {
            model.hideFromPlayer(this.bukkit);
        }
        if ((vfx = this.vfxTicker.getVFX(id)) != null) {
            vfx.hideFromPlayer(this.bukkit);
        }
    }

    private Packet<?> handleAddEntity(PacketPlayOutSpawnEntity addEntityPacket) {
        return this.showModel(addEntityPacket.b()) ? null : addEntityPacket;
    }

    private Packet<?> handleAddMob(PacketPlayOutSpawnEntityLiving addMobPacket) {
        return this.showModel(addMobPacket.b()) ? null : addMobPacket;
    }

    private Packet<?> handleAddPlayer(PacketPlayOutNamedEntitySpawn addPlayerPacket) {
        return this.showModel(addPlayerPacket.c()) ? null : addPlayerPacket;
    }

    private Packet<?> handleRemoveEntities(PacketPlayOutEntityDestroy removeEntitiesPacket) {
        IntListIterator intListIterator = removeEntitiesPacket.b().iterator();
        while (intListIterator.hasNext()) {
            int id = (Integer)intListIterator.next();
            this.hideModel(id);
        }
        return removeEntitiesPacket;
    }

    private Packet<?> handleSetPlayerTeam(PacketPlayOutScoreboardTeam teamPacket) {
        if (teamPacket.e() == null || teamPacket.e().isEmpty()) {
            return teamPacket;
        }
        PacketDataSerializer byteBuf = NetworkUtils.createByteBuf();
        teamPacket.a(byteBuf);
        String name = byteBuf.p();
        byte method = byteBuf.readByte();
        if (method == 1 || method == 2) {
            return teamPacket;
        }
        Set renderers = Sets.newConcurrentHashSet();
        for (String member : teamPacket.e()) {
            UUID uuid;
            try {
                uuid = UUID.fromString(member);
            }
            catch (IllegalArgumentException ignored) {
                Player player = Bukkit.getPlayerExact((String)member);
                if (player == null) continue;
                uuid = player.getUniqueId();
            }
            ModeledEntity model = ModelEngineAPI.getModeledEntity(uuid);
            if (model == null) continue;
            for (ActiveModel activeModel : model.getModels().values()) {
                for (BoneRenderer renderer : activeModel.getRendererHandler().getFakeEntity().values()) {
                    renderers.add(renderer.getRendererUUID().toString());
                }
            }
        }
        PacketPlayOutScoreboardTeam.b parameters = method == 0 ? new PacketPlayOutScoreboardTeam.b(byteBuf) : null;
        List players = byteBuf.a(PacketDataSerializer::p);
        players.addAll(renderers);
        byteBuf.a(name);
        byteBuf.writeByte((int)method);
        if (method == 0) {
            parameters.a(byteBuf);
        }
        byteBuf.a((Collection)players, PacketDataSerializer::a);
        return new PacketPlayOutScoreboardTeam(byteBuf);
    }

    private Packet<?> handleSetEntityData(PacketPlayOutEntityMetadata dataPacket) {
        if (dataPacket.c() != this.player.ae()) {
            return dataPacket;
        }
        ModeledEntity model = ModelEngineAPI.getModeledEntity(this.player.cm());
        if (model == null || model.isBaseEntityVisible()) {
            return dataPacket;
        }
        ModelEngineAPI.getEntityHandler().setSelfFakeInvisible(this.bukkit, true);
        return null;
    }

    private Packet<?> handlePlayerInput(PacketPlayInSteerVehicle inputPacket) {
        MountController controller = ModelEngineAPI.getPlayerMountController(this.player.cm());
        if (controller != null) {
            MountController.MountInput input = new MountController.MountInput(inputPacket.b(), inputPacket.c(), inputPacket.d(), inputPacket.e());
            controller.setInput(input);
        }
        return inputPacket;
    }

    private Packet<?> handleInteract(PacketPlayInUseEntity interactPacket) {
        Integer relayed = ModelEngineAPI.api.getInteractionTicker().getRelayedId(this.player.ae());
        if (relayed != null) {
            return new ServerboundInteractPacketWrapper(relayed, interactPacket);
        }
        return interactPacket;
    }
}

