/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R1.entity.fake.vfx;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.generator.BaseItemEnum;
import com.ticxo.modelengine.api.model.vfx.VFX;
import com.ticxo.modelengine.api.nms.entity.fake.FakeEntity;
import com.ticxo.modelengine.api.nms.entity.fake.VFXRenderer;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_18_R1.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_18_R1.entity.fake.FakeArmorStand;
import com.ticxo.modelengine.nms.v1_18_R1.network.NetworkUtils;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.Vector;

public class VFXRendererImpl
implements VFXRenderer {
    private static final ItemStack empty = new ItemStack(Material.AIR);
    private final VFX vfx;
    private final RangeManager rangeManager;
    private FakeAreaEffectCloud cloud;
    private FakeArmorStand armorStand;
    private ItemStack item;
    private boolean isItemDirty;
    private Color color;
    private boolean isEnchant;
    private boolean isModelVisible = true;

    public VFXRendererImpl(VFX vfx) {
        this.vfx = vfx;
        this.rangeManager = vfx.getRangeManager();
    }

    @Override
    public void initialize() {
        Vector pos = this.vfx.getPosition();
        boolean isSmall = this.vfx.isSmall();
        this.cloud = new FakeAreaEffectCloud(pos.getX(), pos.getY(), pos.getZ());
        this.cloud.setSmall(isSmall);
        this.cloud.setDisplay(FakeEntity.DisplaySlot.HEAD);
        this.armorStand = new FakeArmorStand(pos.getX(), pos.getY(), pos.getZ());
        this.armorStand.setRotation(this.vfx.getRotation());
        this.armorStand.setInvisible(true);
        this.armorStand.setSmall(isSmall);
        this.armorStand.setDisplay(FakeEntity.DisplaySlot.HEAD);
        this.item = ModelEngineAPI.api.getGenerator().getBaseItemType().create();
        this.setColor(this.vfx.getColor());
        this.setData(this.vfx.getData());
        this.setEnchant(this.vfx.isEnchant());
        this.setModelVisible(this.vfx.isVisible());
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.vfx.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        PacketPlayOutMount mount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudSpawn, cloudMeta, armorSpawn, armorMeta, mount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorEquip}));
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity armorSpawn = this.armorStand.spawn(this.vfx.getYaw());
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(true);
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        PacketPlayOutMount mount = this.cloud.addPassengers(this.armorStand.getEntityId());
        NetworkUtils.send(player, new Packet[]{cloudSpawn, cloudMeta, armorSpawn, armorMeta, mount});
        ModelEngineAPI.getModelTicker().queueTask(() -> NetworkUtils.send(player, new Packet[]{armorEquip}));
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.armorStand.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        this.armorStand.setRotation(this.vfx.getRotation());
        this.armorStand.getLocation().zero().add(this.vfx.getPosition());
        PacketPlayOutEntityTeleport cloudPosition = this.cloud.updatePosition(this.vfx.getPosition());
        PacketPlayOutEntity.PacketPlayOutEntityLook armorYaw = this.armorStand.updateYaw(this.vfx.getYaw(), false);
        PacketPlayOutEntityMetadata armorPose = this.armorStand.updateMeta(false);
        PacketPlayOutEntityEquipment armorEquip = null;
        if (this.isItemDirty) {
            armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
            this.isItemDirty = false;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudPosition, armorYaw, armorPose, armorEquip});
    }

    @Override
    public void updateModel() {
        PacketPlayOutEntityEquipment armorEquip = this.armorStand.updateEquipment(this.isModelVisible ? this.item : empty);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorEquip});
    }

    @Override
    public void setSmall(boolean flag) {
        this.armorStand.setSmall(flag);
        this.cloud.setSmall(flag);
    }

    @Override
    public void setModel(ItemStack item) {
        this.item = item;
        this.isItemDirty = true;
    }

    @Override
    public void setModelVisible(boolean flag) {
        this.isModelVisible = flag;
        this.isItemDirty = true;
    }

    @Override
    public void setGlowing(boolean flag) {
        this.armorStand.setGlowing(flag);
        PacketPlayOutEntityMetadata armorMeta = this.armorStand.updateMeta(false);
        if (armorMeta == null) {
            return;
        }
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{armorMeta});
    }

    @Override
    public void setColor(Color color) {
        if (color.equals((Object)this.color)) {
            return;
        }
        this.color = color;
        BaseItemEnum baseItemEnum = ModelEngineAPI.api.getGenerator().getBaseItemType();
        ItemMeta meta = this.item.getItemMeta();
        baseItemEnum.color(meta, color);
        this.item.setItemMeta(meta);
        this.isItemDirty = true;
    }

    @Override
    public void setEnchant(boolean flag) {
        if (this.isEnchant == flag) {
            return;
        }
        this.isEnchant = flag;
        if (flag) {
            this.item.addUnsafeEnchantment(Enchantment.VANISHING_CURSE, 1);
        } else {
            this.item.removeEnchantment(Enchantment.VANISHING_CURSE);
        }
        this.isItemDirty = true;
    }

    @Override
    public void setData(int data) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            return;
        }
        meta.setCustomModelData(Integer.valueOf(data));
        this.item.setItemMeta(meta);
        this.isItemDirty = true;
    }

    @Override
    public void createRealRenderer() {
        this.armorStand.createRealRenderer(this.vfx.getBase().getWorld(), this.isModelVisible ? this.item : empty);
    }

    @Override
    public UUID getRendererUUID() {
        return this.armorStand.getUuid();
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeArmorStand getArmorStand() {
        return this.armorStand;
    }
}

