/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R1.entity.fake.bone;

import com.ticxo.modelengine.api.model.bone.ModelBone;
import com.ticxo.modelengine.api.nms.entity.fake.LeashPoint;
import com.ticxo.modelengine.api.nms.entity.wrapper.RangeManager;
import com.ticxo.modelengine.nms.v1_18_R1.entity.fake.FakeAreaEffectCloud;
import com.ticxo.modelengine.nms.v1_18_R1.entity.fake.FakeSlime;
import com.ticxo.modelengine.nms.v1_18_R1.network.NetworkUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class LeashPointImplB
implements LeashPoint {
    private ModelBone bone;
    private RangeManager rangeManager;
    private FakeAreaEffectCloud cloud;
    private FakeSlime slime;
    private int holder;
    private boolean isInitialized = false;

    public LeashPointImplB(ModelBone bone) {
        this.setBone(bone);
    }

    @Override
    public void setBone(ModelBone bone) {
        this.bone = bone;
        this.rangeManager = bone.getActiveModel().getModeledEntity().getRangeManager();
    }

    @Override
    public void initialize() {
        this.cloud = new FakeAreaEffectCloud(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.slime = new FakeSlime(this.bone.getPosition().getX(), this.bone.getPosition().getY(), this.bone.getPosition().getZ());
        this.isInitialized = true;
    }

    @Override
    public void spawn() {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity slimeSpawn = this.slime.spawn();
        PacketPlayOutEntityMetadata slimeMeta = this.slime.meta();
        PacketPlayOutMount mount = this.cloud.addPassengers(this.slime.getEntityId());
        PacketPlayOutAttachEntity link = this.slime.leash(this.holder);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudSpawn, cloudMeta, slimeSpawn, slimeMeta, mount, link});
    }

    @Override
    public void spawn(Player player) {
        PacketPlayOutSpawnEntity cloudSpawn = this.cloud.spawn();
        PacketPlayOutEntityMetadata cloudMeta = this.cloud.meta();
        PacketPlayOutSpawnEntity slimeSpawn = this.slime.spawn();
        PacketPlayOutEntityMetadata slimeMeta = this.slime.meta();
        PacketPlayOutMount mount = this.cloud.addPassengers(this.slime.getEntityId());
        PacketPlayOutAttachEntity link = this.slime.leash(this.holder);
        NetworkUtils.send(player, new Packet[]{cloudSpawn, cloudMeta, slimeSpawn, slimeMeta, mount, link});
    }

    @Override
    public void despawn() {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.slime.getEntityId()});
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{remove});
    }

    @Override
    public void despawn(Player player) {
        PacketPlayOutEntityDestroy remove = new PacketPlayOutEntityDestroy(new int[]{this.cloud.getEntityId(), this.slime.getEntityId()});
        NetworkUtils.send(player, new Packet[]{remove});
    }

    @Override
    public void update() {
        if (!this.isInitialized) {
            return;
        }
        Vector pos = this.bone.getPosition();
        this.slime.getLocation().zero().add(pos);
        PacketPlayOutEntityTeleport cloudPosition = this.cloud.updatePosition(pos);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{cloudPosition});
    }

    @Override
    public int getLeashId() {
        return this.slime.getEntityId();
    }

    @Override
    public void setHolder(int id) {
        if (this.holder == id) {
            return;
        }
        this.holder = id;
        PacketPlayOutAttachEntity link = this.slime.leash(id);
        NetworkUtils.send(this.rangeManager.getPlayerInRange(), new Packet[]{link});
    }

    public FakeAreaEffectCloud getCloud() {
        return this.cloud;
    }

    public FakeSlime getSlime() {
        return this.slime;
    }

    @Override
    public int getHolder() {
        return this.holder;
    }
}

