/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_18_R1.entity.controller;

import com.ticxo.modelengine.api.command.annotations.CommandAccessible;
import com.ticxo.modelengine.api.nms.entity.wrapper.BodyRotationController;
import com.ticxo.modelengine.api.utils.math.TMath;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;

@CommandAccessible(value={BodyRotationController.class})
public class BodyRotationControlWrapper
extends EntityAIBodyControl
implements BodyRotationController {
    private final EntityInsentient mob;
    private boolean isHeadClampUneven;
    private boolean isBodyClampUneven;
    private float maxHeadAngle;
    private float maxBodyAngle;
    private float minHeadAngle;
    private float minBodyAngle;
    private boolean playerMode;
    private float stableAngle = 15.0f;
    private int rotationDelay = 10;
    private int rotationDuration = 10;
    private int headStableTime;
    private float lastStableYHeadRot;

    public BodyRotationControlWrapper(EntityInsentient mob) {
        super(mob);
        this.mob = mob;
        this.maxHeadAngle = mob.U();
        this.maxBodyAngle = mob.U();
        this.minHeadAngle = -this.maxHeadAngle;
        this.minBodyAngle = -this.minBodyAngle;
    }

    public void a() {
        if (this.isMoving()) {
            this.mob.aY = this.mob.dm();
            this.rotateHeadIfNecessary();
            this.lastStableYHeadRot = this.mob.ba;
            this.headStableTime = 0;
        } else if (this.notCarryingMobPassengers()) {
            if (Math.abs(this.mob.ba - this.lastStableYHeadRot) > this.stableAngle) {
                this.headStableTime = 0;
                this.lastStableYHeadRot = this.mob.ba;
                this.rotateBodyIfNecessary();
            } else if (!this.playerMode) {
                ++this.headStableTime;
                if (this.headStableTime > this.rotationDelay) {
                    this.rotateHeadTowardsFront();
                }
            }
        }
    }

    @Override
    public void setYHeadRot(float rot) {
        this.mob.ba = rot;
    }

    @Override
    public float getYHeadRot() {
        return this.mob.ba;
    }

    @Override
    public float getXHeadRot() {
        return this.mob.dn();
    }

    @Override
    public void setYBodyRot(float rot) {
        this.mob.aY = rot;
    }

    @Override
    public float getYBodyRot() {
        return this.mob.aY;
    }

    private void rotateBodyIfNecessary() {
        this.mob.aY = TMath.rotateIfNecessary(this.mob.aY, this.mob.ba, this.isBodyClampUneven ? this.minBodyAngle : -this.maxBodyAngle, this.maxBodyAngle);
    }

    private void rotateHeadIfNecessary() {
        this.mob.ba = TMath.rotateIfNecessary(this.mob.ba, this.mob.aY, this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle, this.maxHeadAngle);
    }

    private void rotateHeadTowardsFront() {
        float ratio = (float)(this.headStableTime - this.rotationDelay) / (float)this.rotationDuration;
        float clampedRatio = TMath.clamp(ratio, 0.0f, 1.0f);
        float maxClamp = this.maxHeadAngle * (1.0f - clampedRatio);
        float minClamp = (this.isHeadClampUneven ? this.minHeadAngle : -this.maxHeadAngle) * (1.0f - clampedRatio);
        this.mob.aY = TMath.rotateIfNecessary(this.mob.aY, this.mob.ba, minClamp, maxClamp);
    }

    private boolean notCarryingMobPassengers() {
        return !(this.mob.cG() instanceof EntityInsentient);
    }

    private boolean isMoving() {
        double dZ;
        double dX = this.mob.dc() - this.mob.u;
        return dX * dX + (dZ = this.mob.di() - this.mob.w) * dZ > 2.500000277905201E-7;
    }

    @Override
    public boolean isHeadClampUneven() {
        return this.isHeadClampUneven;
    }

    @Override
    public void setHeadClampUneven(boolean isHeadClampUneven) {
        this.isHeadClampUneven = isHeadClampUneven;
    }

    @Override
    public boolean isBodyClampUneven() {
        return this.isBodyClampUneven;
    }

    @Override
    public void setBodyClampUneven(boolean isBodyClampUneven) {
        this.isBodyClampUneven = isBodyClampUneven;
    }

    @Override
    public float getMaxHeadAngle() {
        return this.maxHeadAngle;
    }

    @Override
    public void setMaxHeadAngle(float maxHeadAngle) {
        this.maxHeadAngle = maxHeadAngle;
    }

    @Override
    public float getMaxBodyAngle() {
        return this.maxBodyAngle;
    }

    @Override
    public void setMaxBodyAngle(float maxBodyAngle) {
        this.maxBodyAngle = maxBodyAngle;
    }

    @Override
    public float getMinHeadAngle() {
        return this.minHeadAngle;
    }

    @Override
    public void setMinHeadAngle(float minHeadAngle) {
        this.minHeadAngle = minHeadAngle;
    }

    @Override
    public float getMinBodyAngle() {
        return this.minBodyAngle;
    }

    @Override
    public void setMinBodyAngle(float minBodyAngle) {
        this.minBodyAngle = minBodyAngle;
    }

    @Override
    public boolean isPlayerMode() {
        return this.playerMode;
    }

    @Override
    public void setPlayerMode(boolean playerMode) {
        this.playerMode = playerMode;
    }

    @Override
    public float getStableAngle() {
        return this.stableAngle;
    }

    @Override
    public void setStableAngle(float stableAngle) {
        this.stableAngle = stableAngle;
    }

    @Override
    public int getRotationDelay() {
        return this.rotationDelay;
    }

    @Override
    public void setRotationDelay(int rotationDelay) {
        this.rotationDelay = rotationDelay;
    }

    @Override
    public int getRotationDuration() {
        return this.rotationDuration;
    }

    @Override
    public void setRotationDuration(int rotationDuration) {
        this.rotationDuration = rotationDuration;
    }
}

