/*
 * Decompiled with CFR 0.152.
 */
package com.ticxo.modelengine.nms.v1_17_R1.entity.fake;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.utils.math.TMath;
import com.ticxo.modelengine.nms.v1_17_R1.entity.fake.DataAccessors;
import com.ticxo.modelengine.nms.v1_17_R1.network.NetworkUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.IRegistry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.util.Vector;

public class FakeSlime {
    private final int entityId;
    private final UUID uuid;
    private final Vector location = new Vector();
    private boolean sendCancelPacket;
    private final DataWatcher.Item<Byte> commonDataItem;
    private final DataWatcher.Item<Integer> airTickDataItem;
    private final DataWatcher.Item<Integer> sizeDataItem;

    public FakeSlime(double x, double y, double z) {
        this.entityId = ModelEngineAPI.getEntityHandler().getEntityCounter().incrementAndGet();
        this.uuid = UUID.randomUUID();
        this.location.setX(x).setY(y).setZ(z);
        this.commonDataItem = new DataWatcher.Item(DataAccessors.COMMON_DATA, (Object)32);
        this.airTickDataItem = new DataWatcher.Item(DataAccessors.AIR_TICK, (Object)Integer.MAX_VALUE);
        this.sizeDataItem = new DataWatcher.Item(DataAccessors.SIZE_DATA, (Object)0);
    }

    public void setSize(int size) {
        this.sizeDataItem.a((Object)size);
        this.sizeDataItem.a(true);
    }

    public PacketPlayOutSpawnEntity spawn() {
        PacketDataSerializer spawn = NetworkUtils.createByteBuf();
        spawn.d(this.entityId);
        spawn.a(this.uuid);
        spawn.d(IRegistry.Y.getId((Object)EntityTypes.aD));
        spawn.writeDouble(this.location.getX());
        spawn.writeDouble(this.location.getY());
        spawn.writeDouble(this.location.getZ());
        spawn.writeByte(0);
        spawn.writeByte(0);
        spawn.writeInt(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        spawn.writeShort(0);
        return new PacketPlayOutSpawnEntity(spawn);
    }

    public PacketPlayOutEntityMetadata meta() {
        PacketDataSerializer data = NetworkUtils.createByteBuf();
        data.d(this.entityId);
        DataWatcher.a(List.of(this.commonDataItem, this.airTickDataItem, this.sizeDataItem), (PacketDataSerializer)data);
        return new PacketPlayOutEntityMetadata(data);
    }

    public PacketPlayOutAttachEntity leash(int holder) {
        PacketDataSerializer data = NetworkUtils.createByteBuf();
        data.writeInt(this.entityId);
        data.writeInt(holder);
        return new PacketPlayOutAttachEntity(data);
    }

    public PacketPlayOutEntityTeleport updatePosition(Vector vector) {
        if (TMath.isSimilar(this.location, vector)) {
            return null;
        }
        this.location.zero().add(vector);
        return this.createTeleportPacket(vector.getX(), vector.getY(), vector.getZ());
    }

    public PacketPlayOutEntityTeleport updatePositionCalibrated(Vector vector) {
        if (TMath.isSimilar(this.location, vector)) {
            if (this.sendCancelPacket) {
                this.sendCancelPacket = false;
                return this.createTeleportPacket(this.location.getX(), this.location.getY(), this.location.getZ());
            }
            return null;
        }
        this.sendCancelPacket = true;
        Vector prevLoc = this.location.clone();
        this.location.zero().add(vector);
        vector = TMath.lerp(prevLoc, vector, 3.0);
        return this.createTeleportPacket(vector.getX(), vector.getY(), vector.getZ());
    }

    public PacketPlayOutMount addPassenger(int id) {
        PacketDataSerializer mount = NetworkUtils.createByteBuf();
        mount.d(this.entityId);
        mount.d(1);
        mount.d(id);
        return new PacketPlayOutMount(mount);
    }

    private PacketPlayOutEntityTeleport createTeleportPacket(double x, double y, double z) {
        PacketDataSerializer pos = NetworkUtils.createByteBuf();
        pos.d(this.entityId);
        pos.writeDouble(x);
        pos.writeDouble(y);
        pos.writeDouble(z);
        pos.writeByte(0);
        pos.writeByte(0);
        pos.writeBoolean(false);
        return new PacketPlayOutEntityTeleport(pos);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Vector getLocation() {
        return this.location;
    }
}

